/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DutyDetailItemDTO;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.targetcost.vo.DutyDetailVO;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"duty"})
public class DutyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDutyService service;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private ITotalExecutionService totalExecutionService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DutyVO> saveOrUpdate(@RequestBody DutyVO saveOrUpdateVO) {
        Date date = this.queryOneTime(saveOrUpdateVO.getProjectId());
        if (date != null) {
            saveOrUpdateVO.setOneTime(date);
        }
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DutyVO> queryDetail(Long id) {
        DutyVO dutyVO = this.service.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)dutyVO);
    }

    @RequestMapping(value={"/queryDutyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DutyVO> queryDutyDetail(Long projectId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(DutyEntity::getProjectId, (Object)projectId);
        query.in(DutyEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        List dutyEntities = this.service.list((Wrapper)query);
        if (dutyEntities.size() == 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u6ca1\u6709\u76ee\u6807\u6210\u672c\uff0c\u8bf7\u5207\u6362\u9879\u76ee");
        }
        DutyVO dutyVO = null;
        for (int i = 0; i <= dutyEntities.size(); ++i) {
            dutyVO = (DutyVO)BeanMapper.map(dutyEntities.get(0), DutyVO.class);
        }
        DutyVO dutyVO1 = this.service.queryDetail(dutyVO.getId(), true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)dutyVO1);
    }

    @RequestMapping(value={"/queryReviseDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DutyVO> queryReviseDetail(Long id) {
        DutyVO changeVO = this.service.queryReviseDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/linkFeeScale"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExecutionLinkVO>> linkFeeScale(@RequestParam Long projectId, Long id) {
        List<ExecutionLinkVO> linkVOS = this.service.linkFeeScale(projectId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", linkVOS);
    }

    @RequestMapping(value={"/queryDoc"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> queryDoc(@RequestParam Long projectId) {
        Map<Long, BigDecimal> linkVOS = this.service.queryDoc(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", linkVOS);
    }

    @RequestMapping(value={"/querySumPreTypeAmount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> querySumPreTypeAmount(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.service.querySumPreTypeAmount(projectId));
    }

    @RequestMapping(value={"/queryDocDutyDetailItem"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, DutyDetailItemVO>> queryDocDutyDetailItem(@RequestParam Long projectId, @RequestParam Integer docType) {
        Map<Long, DutyDetailItemVO> linkVOS = this.service.queryDocDutyDetailItem(projectId, docType);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", linkVOS);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody DutyVO dutyVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(dutyVO));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DutyVO> vos) {
        this.service.deleteList(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryParam queryParam = (QueryParam)BeanMapper.map((Object)param, QueryParam.class);
        IPage page = this.service.queryPage(this.buildParam(param, true), false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List dutyVOS = BeanMapper.mapList((Iterable)page.getRecords(), DutyVO.class);
        for (DutyVO dutyVO : dutyVOS) {
            if (!dutyVO.getGatherFlag().booleanValue()) continue;
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)dutyVO.getProjectId()));
            List childList = this.service.queryList(this.buildParam(queryParam, false));
            for (DutyEntity dutyEntity : childList) {
                DutyVO vo = (DutyVO)BeanMapper.map((Object)((Object)dutyEntity), DutyVO.class);
                vo.setParentId(dutyVO.getId());
                dutyVO.getChildren().add(vo);
            }
        }
        pageData.setRecords(TreeNodeBUtil.buildTree(dutyVOS));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private QueryParam buildParam(QueryParam param, Boolean isParent) {
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        c1.getParams().put("gatherFlag", new Parameter("eq", (Object)isParent));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("dutyVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        if (isParent.booleanValue()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
            List dutyEntities = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)dutyEntities)) {
                ComplexParam c6 = new ComplexParam();
                c6.setLogic("and");
                c6.getParams().put("projectId", new Parameter("not_in", dutyEntities.stream().map(DutyEntity::getProjectId).collect(Collectors.toList())));
                complex2.getComplexParams().add(c6);
            }
        }
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        return param;
    }

    @RequestMapping(value={"/queryGatherList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryGatherList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryHistoryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryHistoryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter("eq", (Object)false));
        param.getParams().put("enableState", new Parameter("eq", (Object)false));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(val -> {
            DutyVO exportVO = (DutyVO)BeanMapper.map((Object)val, DutyVO.class);
            switch (val.getBillState()) {
                case 0: {
                    exportVO.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    exportVO.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    exportVO.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    exportVO.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    exportVO.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    exportVO.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
            switch (val.getChangeState()) {
                case 0: {
                    exportVO.setChangeStateName("\u672a\u53d8\u66f4");
                    break;
                }
                case 1: {
                    exportVO.setChangeStateName("\u53d8\u66f4\u4e2d");
                    break;
                }
                case 2: {
                    exportVO.setChangeStateName("\u5df2\u53d8\u66f4");
                }
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("DutyExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDutyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> refDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDutyDetailTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTree(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Map conditionMap;
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap2 = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap2.get("projectId")) {
                projectId = Long.valueOf(conditionMap2.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)((DutyEntity)((Object)list.get(0))).getId()));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("docType")) {
            queryParam.getParams().put("docType", new Parameter("eq", (Object)Integer.valueOf(conditionMap.get("docType").toString())));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        List result = ResultAsTree.createTreeData((List)resultMapList);
        return result;
    }

    @RequestMapping(value={"refDutyItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        DutyDetailEntity dutyDetailEntity;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (dutyDetailEntity = (DutyDetailEntity)this.dutyDetailService.selectById(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            queryParam.getParams().put("dutyDetailId", new Parameter("eq", (Object)dutyDetailEntity.getId()));
        }
        IPage pageData = this.dutyDetailItemService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDutyDetailTreePersonal"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreePersonal(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)1));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/queryDutyDetailTreeMajor"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeMajor(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)2));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/queryDutyDetailTreeMaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeMaterial(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        ArrayList<Long> categoryIdsList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            boolean categoryIdFlag = false;
            if (null != conditionMap.get("categoryId")) {
                categoryIdFlag = true;
                String categoryId = conditionMap.get("categoryId").toString();
                if (categoryId.indexOf(",") > 0) {
                    String[] strings;
                    for (String str : strings = categoryId.split(",")) {
                        categoryIdsList.add(Long.valueOf(str));
                    }
                } else {
                    categoryIdsList.add(Long.valueOf(categoryId));
                }
            }
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else if (!categoryIdFlag) {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        if (categoryIdsList.size() > 0) {
            queryParam.getParams().put("categoryId", new Parameter("in", categoryIdsList));
        }
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)3));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/queryDutyDetailTreeEquipment"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeEquipment(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)4));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"refDutyDetailItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refDutyDetailItemPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        Long dutyDetailId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            dutyDetailId = Long.parseLong(relyCondition.split("=")[1]);
        }
        queryParam.getParams().put("dutyDetailId", new Parameter("eq", (Object)dutyDetailId));
        queryParam.getOrderMap().put("code", "asc");
        IPage pageData = this.dutyDetailItemService.queryPage(queryParam);
        DutyDetailEntity dutyDetailEntity = (DutyDetailEntity)this.dutyDetailService.selectById(dutyDetailId);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords()) && DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(dutyDetailEntity.getDocType())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DetailCacheEntity::getDutyDetailId, (Object)dutyDetailId);
            queryWrapper.isNotNull(DetailCacheEntity::getDutyItemId);
            List detailCacheEntities = this.detailCacheService.list((Wrapper)queryWrapper);
            Map map = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDutyItemId, Function.identity(), (key1, key2) -> key1));
            Iterator iterator = pageData.getRecords().iterator();
            while (iterator.hasNext()) {
                DutyDetailItemEntity itemEntity;
                itemEntity.setContNum(map.containsKey((itemEntity = (DutyDetailItemEntity)((Object)iterator.next())).getId()) ? ((DetailCacheEntity)((Object)map.get(itemEntity.getId()))).getContNum() : null);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refDutyDetailItemPageNoMerge"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refDutyDetailItemPageNoMerge(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        Long dutyDetailId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            dutyDetailId = Long.parseLong(relyCondition.split("=")[1]);
        }
        queryParam.getParams().put("dutyDetailId", new Parameter("eq", (Object)dutyDetailId));
        queryParam.getOrderMap().put("code", "asc");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getId, (Object)dutyDetailId);
        DutyDetailEntity dutyDetailEntity = (DutyDetailEntity)this.dutyDetailService.getOne((Wrapper)queryWrapper, false);
        List dutyDetailItemEntityList = new ArrayList();
        if (dutyDetailEntity != null) {
            LambdaQueryWrapper queryWrapperDuty = new LambdaQueryWrapper();
            queryWrapperDuty.eq(BaseEntity::getId, (Object)dutyDetailEntity.getDutyId());
            DutyEntity dutyEntity = (DutyEntity)((Object)this.service.getOne((Wrapper)queryWrapperDuty, false));
            if (dutyEntity != null) {
                LambdaQueryWrapper queryWrapperDuty1 = new LambdaQueryWrapper();
                queryWrapperDuty1.eq(DutyEntity::getProjectId, (Object)dutyEntity.getProjectId());
                queryWrapperDuty1.eq(DutyEntity::getFeeId, (Object)dutyEntity.getFeeId());
                queryWrapperDuty1.eq(DutyEntity::getGatherFlag, (Object)false);
                queryWrapperDuty1.eq(DutyEntity::getEnableState, (Object)true);
                List dutyEntityList = this.service.list((Wrapper)queryWrapperDuty1);
                if (CollectionUtils.isNotEmpty((Collection)dutyEntityList)) {
                    LambdaQueryWrapper detailEntityQueryWrapper = new LambdaQueryWrapper();
                    detailEntityQueryWrapper.eq(DutyDetailEntity::getProjectId, (Object)dutyEntity.getProjectId());
                    detailEntityQueryWrapper.eq(DutyDetailEntity::getFeeDetailId, (Object)dutyDetailEntity.getFeeDetailId());
                    detailEntityQueryWrapper.in(DutyDetailEntity::getDutyId, (Collection)dutyEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                    List dutyDetailEntityList = this.dutyDetailService.list((Wrapper)detailEntityQueryWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)dutyDetailEntityList)) {
                        LambdaQueryWrapper dutyDetailEntityQueryWrapper = new LambdaQueryWrapper();
                        dutyDetailEntityQueryWrapper.in(DutyDetailItemEntity::getDutyDetailId, (Collection)dutyDetailEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                        dutyDetailEntityQueryWrapper.orderByAsc(DutyDetailItemEntity::getCode);
                        dutyDetailItemEntityList = this.dutyDetailItemService.list((Wrapper)dutyDetailEntityQueryWrapper);
                    }
                }
            }
        }
        DutyDetailEntity detailItemEntities = (DutyDetailEntity)this.dutyDetailService.selectById(dutyDetailId);
        if (CollectionUtils.isNotEmpty(dutyDetailItemEntityList) && DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(detailItemEntities.getDocType())) {
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.eq(DetailCacheEntity::getDutyDetailId, (Object)dutyDetailId);
            queryWrapper1.isNotNull(DetailCacheEntity::getDutyItemId);
            List detailCacheEntities = this.detailCacheService.list((Wrapper)queryWrapper1);
            Map map = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDutyItemId, Function.identity(), (key1, key2) -> key1));
            Iterator iterator = dutyDetailItemEntityList.iterator();
            while (iterator.hasNext()) {
                DutyDetailItemEntity itemEntity;
                itemEntity.setContNum(map.containsKey((itemEntity = (DutyDetailItemEntity)((Object)iterator.next())).getId()) ? ((DetailCacheEntity)((Object)map.get(itemEntity.getId()))).getContNum() : null);
            }
        }
        Page page = new Page();
        page = new Page(page.getCurrent(), (long)queryParam.getPageSize(), (long)dutyDetailItemEntityList.size());
        page.setRecords(dutyDetailItemEntityList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Date queryOneTime(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(DutyEntity::getDutyVersion, (Object)1);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        if (dutyEntity != null) {
            return dutyEntity.getCreateTime();
        }
        return null;
    }

    @RequestMapping(value={"/queryDutyDetailTreeMaterialZzyj"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeMaterialZzyj(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        CommonResponse categoryIdList;
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)3));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        if ((categoryIdList = this.shareMaterialApi.queryUnenabledCategoryListId()).getCode() == 0) {
            List data = (List)categoryIdList.getData();
            queryParam.getParams().put("categoryId", new Parameter("not_in", (Object)data));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/queryDutyDetailTreePersonalZzyj"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreePersonalZzyj(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        CommonResponse categoryIdList;
        this.logger.debug("condition is " + condition);
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            } else {
                return null;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Long dutyId = ((DutyEntity)((Object)list.get(0))).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter("eq", (Object)dutyId));
        queryParam.getParams().put("docType", new Parameter("eq", (Object)1));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        if ((categoryIdList = this.shareLabsubApi.queryUnenabledCategoryListId()).getCode() == 0) {
            List data = (List)categoryIdList.getData();
            queryParam.getParams().put("categoryId", new Parameter("not_in", (Object)data));
        }
        List dataList = this.dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = this.dutyDetailService.queryDutyDetailParentId(dutyId, dataList);
        ArrayList<DutyDetailVO> dutyDetailVOList = new ArrayList<DutyDetailVO>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            DutyDetailVO vo = (DutyDetailVO)BeanMapper.map((Object)dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for (Map map : resultMapList) {
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"refDutyDetailItemPageZzyj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refDutyDetailItemPageZzyj(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        CommonResponse categoryIdList;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        Long dutyDetailId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            dutyDetailId = Long.parseLong(relyCondition.split("=")[1]);
        }
        if ((categoryIdList = this.shareMaterialApi.queryUnenabledCategoryListId()).getCode() == 0) {
            List data = (List)categoryIdList.getData();
            queryParam.getParams().put("categoryId", new Parameter("not_in", (Object)data));
        }
        queryParam.getParams().put("dutyDetailId", new Parameter("eq", (Object)dutyDetailId));
        queryParam.getOrderMap().put("code", "asc");
        IPage pageData = this.dutyDetailItemService.queryPage(queryParam);
        DutyDetailEntity dutyDetailEntity = (DutyDetailEntity)this.dutyDetailService.selectById(dutyDetailId);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords()) && DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(dutyDetailEntity.getDocType())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DetailCacheEntity::getDutyDetailId, (Object)dutyDetailId);
            queryWrapper.isNotNull(DetailCacheEntity::getDutyItemId);
            List detailCacheEntities = this.detailCacheService.list((Wrapper)queryWrapper);
            Map map = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDutyItemId, Function.identity(), (key1, key2) -> key1));
            Iterator iterator = pageData.getRecords().iterator();
            while (iterator.hasNext()) {
                DutyDetailItemEntity itemEntity;
                itemEntity.setContNum(map.containsKey((itemEntity = (DutyDetailItemEntity)((Object)iterator.next())).getId()) ? ((DetailCacheEntity)((Object)map.get(itemEntity.getId()))).getContNum() : null);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDutyIdByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DutyVO> queryDutyIdByProjectId(@RequestParam Long projectId) {
        DutyVO dutyVO = this.service.queryDutyIdByProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)dutyVO);
    }

    @RequestMapping(value={"/gatherDuty"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DutyVO> gatherDuty(Long id) {
        DutyVO dutyVO = this.service.gatherDuty(id);
        return CommonResponse.success((String)"\u91cd\u65b0\u6c47\u603b\u6210\u529f\uff01", (Object)dutyVO);
    }

    @RequestMapping(value={"/historyGather"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> historyGather(@RequestBody List<Long> projIdList) {
        if (CollectionUtils.isNotEmpty(projIdList)) {
            for (Long projId : projIdList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
                queryWrapper.eq(DutyEntity::getProjectId, (Object)projId);
                DutyEntity dutyEntity = (DutyEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
                if (null == dutyEntity) {
                    return CommonResponse.success((String)"\u6b64\u9879\u76ee\u672a\u505a\u8fc7\u8d23\u4efb\u6210\u672c\uff01");
                }
                this.service.gatherDuty(dutyEntity.getId());
                this.totalExecutionService.reCalc(dutyEntity.getProjectId());
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
            List list = this.service.list((Wrapper)queryWrapper);
            for (DutyEntity dutyEntity : list) {
                this.service.gatherDuty(dutyEntity.getId());
                this.totalExecutionService.reCalc(dutyEntity.getProjectId());
            }
        }
        return CommonResponse.success((String)"\u5904\u7406\u5386\u53f2\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExportDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportDetail(HttpServletResponse response, Long zhuId) {
        if (zhuId != null) {
            List<DutyDetailItemDTO> dutyDetailItemDTOS = this.service.excelExportDetail(zhuId);
            HashMap<String, List<DutyDetailItemDTO>> beans = new HashMap<String, List<DutyDetailItemDTO>>();
            beans.put("records", dutyDetailItemDTOS);
            ExcelExport.getInstance().export("DutyDetailExport.xlsx", beans, response);
        }
    }
}

