/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DetailExecutionEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDetailExecutionService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;

public class ReCalcExec {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TC_LOCK = "TC_LOCK::";
    private RequestAttributes context;
    private Long projectId;
    private DutyEntity dutyEntity;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private IDutyDetailService dutyDetailService;
    private IDutyDetailItemService dutyDetailItemService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;
    private ITotalExecutionService totalExecutionService;
    private IDetailExecutionService detailExecutionService;

    public ReCalcExec(RequestAttributes context, Long projectId, DutyEntity dutyEntity, RedissonClient redissonClient, ITotalCacheService totalCacheService, IDetailCacheService detailCacheService, IDutyDetailService dutyDetailService, IDutyDetailItemService dutyDetailItemService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService, ITotalExecutionService totalExecutionService, IDetailExecutionService detailExecutionService) {
        this.context = context;
        this.projectId = projectId;
        this.dutyEntity = dutyEntity;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyDetailService = dutyDetailService;
        this.dutyDetailItemService = dutyDetailItemService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
        this.totalExecutionService = totalExecutionService;
        this.detailExecutionService = detailExecutionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> call() {
        String lockKey = TC_LOCK + this.projectId;
        RLock mylock = this.redissonClient.getLock(lockKey);
        try {
            boolean lock = mylock.tryLock(20L, TimeUnit.SECONDS);
            if (!lock) {
                CommonResponse commonResponse = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + this.projectId));
                return commonResponse;
            }
            this.detailCacheService.deleteByProjectIdPhy(this.projectId);
            this.totalCacheService.deleteByProjectIdPhy(this.projectId);
            if (null == this.dutyEntity) {
                CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u751f\u6548\u7684\u76ee\u6807\u6210\u672c");
                return commonResponse;
            }
            String msg = this.reCalcDetail(this.dutyEntity);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.logger.error("\u91cd\u7b97\u76ee\u6807\u6210\u672c\u6c47\u603b\u7f13\u5b58:" + msg);
            }
            this.reCalcTotal(this.dutyEntity);
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u7b97\u76ee\u6807\u6210\u672c\u6c47\u603b\u7f13\u5b58\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
        }
        finally {
            mylock.unlock();
        }
        this.logger.error("\u91cd\u7b97\u7f13\u5b58\u8868\u6210\u529f");
        return CommonResponse.success((String)"\u91cd\u7b97\u7f13\u5b58\u8868\u6210\u529f");
    }

    private String reCalcDetail(DutyEntity dutyEntity) {
        HashMap<String, DetailCacheEntity> cacheAllMap = new HashMap<String, DetailCacheEntity>();
        LambdaQueryWrapper detailExecQry = new LambdaQueryWrapper();
        detailExecQry.eq(DetailExecutionEntity::getProjectId, (Object)dutyEntity.getProjectId());
        List detailExecList = this.detailExecutionService.list((Wrapper)detailExecQry);
        Map<Long, List<FeeDetailScopeEntity>> scopeMap = this.queryScopeMap();
        Map<Long, List<DutyDetailItemEntity>> itemAllMap = this.queryAllItemMap();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        List detailEntities = this.dutyDetailService.list((Wrapper)queryWrapper);
        for (DutyDetailEntity detailEntity : detailEntities) {
            if (!scopeMap.containsKey(detailEntity.getFeeDetailId())) continue;
            ArrayList<Long> categoryList = new ArrayList();
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId()) {
                LambdaQueryWrapper query = new LambdaQueryWrapper();
                query.eq(FeeDetailEntity::getParentId, (Object)detailEntity.getFeeDetailId());
                List feeDetailEntities = this.feeDetailService.list((Wrapper)query);
                categoryList = feeDetailEntities.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            HashSet<String> scopeSet = new HashSet<String>();
            List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(detailEntity.getFeeDetailId());
            for (FeeDetailScopeEntity scopeEntity : scopeEntityList) {
                scopeSet.add(scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue());
            }
            List<DutyDetailItemEntity> itemEntities = itemAllMap.get(detailEntity.getId());
            if (CollectionUtils.isNotEmpty(itemEntities)) {
                for (DutyDetailItemEntity itemEntity : itemEntities) {
                    String cacheUnKey = detailEntity.getId() + "$" + itemEntity.getDocType() + "$" + itemEntity.getDocId();
                    if (cacheAllMap.containsKey(cacheUnKey)) continue;
                    DetailCacheEntity cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)((Object)itemEntity), DetailCacheEntity.class));
                    cacheEntity.setId(null);
                    cacheEntity.setDutyItemId(itemEntity.getId());
                    cacheAllMap.put(cacheUnKey, cacheEntity);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)detailExecList)) continue;
            for (DetailExecutionEntity detailExecutionEntity : detailExecList) {
                DetailCacheEntity cacheEntity;
                String unKey = detailExecutionEntity.getBussinessType() + "&" + detailExecutionEntity.getProperty();
                if (!scopeSet.contains(unKey) || !this.check(detailEntity, detailExecutionEntity, categoryList)) continue;
                String cacheUnKey = detailEntity.getId() + "$" + detailExecutionEntity.getDocType() + "$" + detailExecutionEntity.getDocId();
                if (cacheAllMap.containsKey(cacheUnKey)) {
                    cacheEntity = (DetailCacheEntity)((Object)cacheAllMap.get(cacheUnKey));
                } else {
                    cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)((Object)detailExecutionEntity), DetailCacheEntity.class));
                    if (detailExecutionEntity.getCategoryFlag().booleanValue()) {
                        cacheEntity.setCode(detailExecutionEntity.getCategoryCode());
                        cacheEntity.setName(detailExecutionEntity.getCategoryName());
                    }
                    cacheEntity.setPrice(null);
                    cacheEntity.setTaxPrice(null);
                    cacheEntity.setModel(detailExecutionEntity.getSpec());
                    cacheEntity.setDutyDetailId(detailEntity.getId());
                    cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                    cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                    cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    cacheEntity.setId(null);
                    cacheEntity.setProjectId(dutyEntity.getProjectId());
                }
                cacheEntity.setBillCategory(detailExecutionEntity.getBillCategory());
                this.setDetailValue(cacheEntity, detailExecutionEntity);
                cacheAllMap.put(cacheUnKey, cacheEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(cacheAllMap.values())) {
            this.detailCacheService.saveOrUpdateBatch(cacheAllMap.values());
        }
        return null;
    }

    private boolean check(DutyDetailEntity detailEntity, DetailExecutionEntity detailExecutionEntity, List<Long> categoryList) {
        if (null == detailEntity.getCategoryId() && !DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(detailExecutionEntity.getDocType())) {
            boolean flag = false;
            if (CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null == detailExecutionEntity.getCategoryInnerCode() || !detailExecutionEntity.getCategoryInnerCode().contains(String.valueOf(category))) continue;
                    flag = true;
                }
            }
            return flag;
        }
        if (!detailEntity.getLeafFlag().booleanValue()) {
            return false;
        }
        if (detailEntity.getDocType().compareTo(detailExecutionEntity.getDocType()) != 0) {
            return false;
        }
        return null != detailExecutionEntity.getCategoryInnerCode() && detailExecutionEntity.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()));
    }

    private void reCalcTotal(DutyEntity dutyEntity) {
        ArrayList<TotalCacheEntity> totalList = new ArrayList<TotalCacheEntity>();
        Map<String, List<TotalExecutionEntity>> totalExecMap = this.queryTotalExecMap();
        this.logger.error("totalExecMap is " + JSONObject.toJSONString(totalExecMap));
        Map<Long, List<DetailCacheEntity>> detailCacheMap = this.queryDetailCacheMap();
        Map<Long, List<FeeDetailScopeEntity>> scopeMap = this.queryScopeMap();
        LambdaQueryWrapper detailQuery = new LambdaQueryWrapper();
        detailQuery.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        List detailEntities = this.dutyDetailService.list((Wrapper)detailQuery);
        for (DutyDetailEntity detailEntity : detailEntities) {
            TotalCacheEntity totalEntity = (TotalCacheEntity)((Object)BeanMapper.map((Object)detailEntity, TotalCacheEntity.class));
            totalEntity.setId(null);
            totalEntity.setCode(detailEntity.getFeeDetailCode());
            totalEntity.setName(detailEntity.getFeeDetailName());
            totalEntity.setDutyDetailId(detailEntity.getId());
            totalEntity.setProjectId(dutyEntity.getProjectId());
            totalEntity.setCreateTime(null);
            totalEntity.setCreateUserCode(null);
            this.setValue(totalEntity, detailCacheMap.get(detailEntity.getId()), totalExecMap, scopeMap);
            totalList.add(totalEntity);
        }
        List resultMapList = BeanMapper.mapList(totalList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);
        this.gatherMnyAndNum(null, treeData);
        ArrayList<TotalCacheEntity> entities = new ArrayList<TotalCacheEntity>();
        this.treeToList(treeData, entities);
        for (TotalCacheEntity entity : entities) {
            if (!BooleanUtils.isTrue((Boolean)entity.getSelfScopeFlag()) || !BooleanUtils.isFalse((Boolean)entity.getLeafFlag()) || null != entity.getAllCostFlag() && !BooleanUtils.isFalse((Boolean)entity.getAllCostFlag())) continue;
            List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(entity.getFeeDetailId());
            for (FeeDetailScopeEntity scopeEntity : scopeEntityList) {
                String key = scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue();
                if (!totalExecMap.containsKey(key)) continue;
                List<TotalExecutionEntity> totalExecutionEntities = totalExecMap.get(key);
                this.setValueByList(entity, totalExecutionEntities);
            }
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            this.totalCacheService.saveOrUpdateBatch(entities);
        }
    }

    private void setValueByList(TotalCacheEntity totalCacheEntity, List<TotalExecutionEntity> totalExecutionEntities) {
        for (TotalExecutionEntity executionEntity : totalExecutionEntities) {
            if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanMoney(), (BigDecimal)executionEntity.getMoney()));
                totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)executionEntity.getTaxMoney()));
                continue;
            }
            if (BillCategoryEnum.\u5408\u540c.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContMoney(), (BigDecimal)executionEntity.getMoney()));
                totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)executionEntity.getTaxMoney()));
                continue;
            }
            if (BillCategoryEnum.\u5165\u5e93.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreMoney(), (BigDecimal)executionEntity.getMoney()));
                totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)executionEntity.getTaxMoney()));
                continue;
            }
            if (!BillCategoryEnum.\u5176\u4ed6.getCode().equals(executionEntity.getBillCategory())) continue;
            totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherMoney(), (BigDecimal)executionEntity.getMoney()));
            totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)executionEntity.getTaxMoney()));
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((TotalCacheEntity)((Object)BeanMapper.map(ypd, TotalCacheEntity.class)));
        }
    }

    private void gatherMnyAndNum(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal planMoney = null;
        BigDecimal planTaxMoney = null;
        BigDecimal outPlanMoney = null;
        BigDecimal outPlanTaxMoney = null;
        BigDecimal contMoney = null;
        BigDecimal contTaxMoney = null;
        BigDecimal outContMoney = null;
        BigDecimal outContTaxMoney = null;
        BigDecimal storeMoney = null;
        BigDecimal storeTaxMoney = null;
        BigDecimal outStoreMoney = null;
        BigDecimal outStoreTaxMoney = null;
        BigDecimal otherMoney = null;
        BigDecimal otherTaxMoney = null;
        BigDecimal outOtherMoney = null;
        BigDecimal outOtherTaxMoney = null;
        Boolean allCostFlag = false;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMnyAndNum(ypd, (List)ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, (BigDecimal)this.getBigDecimalValue(ypd, "taxMny"));
            planMoney = ComputeUtil.safeAdd(planMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planMoney"));
            planTaxMoney = ComputeUtil.safeAdd(planTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planTaxMoney"));
            outPlanMoney = ComputeUtil.safeAdd(outPlanMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanMoney"));
            outPlanTaxMoney = ComputeUtil.safeAdd(outPlanTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanTaxMoney"));
            contMoney = ComputeUtil.safeAdd(contMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contMoney"));
            contTaxMoney = ComputeUtil.safeAdd(contTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contTaxMoney"));
            outContMoney = ComputeUtil.safeAdd(outContMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContMoney"));
            outContTaxMoney = ComputeUtil.safeAdd(outContTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContTaxMoney"));
            storeMoney = ComputeUtil.safeAdd(storeMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeMoney"));
            storeTaxMoney = ComputeUtil.safeAdd(storeTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeTaxMoney"));
            outStoreMoney = ComputeUtil.safeAdd(outStoreMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreMoney"));
            outStoreTaxMoney = ComputeUtil.safeAdd(outStoreTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreTaxMoney"));
            otherMoney = ComputeUtil.safeAdd(otherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherMoney"));
            otherTaxMoney = ComputeUtil.safeAdd(otherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherTaxMoney"));
            outOtherMoney = ComputeUtil.safeAdd(outOtherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherMoney"));
            outOtherTaxMoney = ComputeUtil.safeAdd(outOtherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherTaxMoney"));
            if (!DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(ypd.get("docType"))) continue;
            allCostFlag = true;
        }
        if (now != null) {
            now.put("allCostFlag", allCostFlag);
            now.put("outPlanMoney", outPlanMoney);
            now.put("outPlanTaxMoney", outPlanTaxMoney);
            now.put("outContMoney", outContMoney);
            now.put("outContTaxMoney", outContTaxMoney);
            now.put("outStoreMoney", outStoreMoney);
            now.put("outStoreTaxMoney", outStoreTaxMoney);
            now.put("outOtherMoney", outOtherMoney);
            now.put("outOtherTaxMoney", outOtherTaxMoney);
            if (!((Boolean)now.get("selfScopeFlag")).booleanValue() || !((Boolean)now.get("leafFlag")).booleanValue() && allCostFlag.booleanValue()) {
                now.put("planMoney", planMoney);
                now.put("planTaxMoney", planTaxMoney);
                now.put("contMoney", contMoney);
                now.put("contTaxMoney", contTaxMoney);
                now.put("storeMoney", storeMoney);
                now.put("storeTaxMoney", storeTaxMoney);
                now.put("otherMoney", otherMoney);
                now.put("otherTaxMoney", otherTaxMoney);
            }
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void setValue(TotalCacheEntity totalCacheEntity, List<DetailCacheEntity> itemEntityList, Map<String, List<TotalExecutionEntity>> totalExecMap, Map<Long, List<FeeDetailScopeEntity>> scopeMap) {
        block3: {
            block2: {
                totalCacheEntity.setPlanMoney(null);
                totalCacheEntity.setPlanNum(null);
                totalCacheEntity.setPlanTaxMoney(null);
                totalCacheEntity.setOutPlanMoney(null);
                totalCacheEntity.setOutPlanTaxMoney(null);
                totalCacheEntity.setContMoney(null);
                totalCacheEntity.setContNum(null);
                totalCacheEntity.setContTaxMoney(null);
                totalCacheEntity.setOutContMoney(null);
                totalCacheEntity.setOutContTaxMoney(null);
                totalCacheEntity.setStoreMoney(null);
                totalCacheEntity.setStoreNum(null);
                totalCacheEntity.setStoreTaxMoney(null);
                totalCacheEntity.setOutStoreMoney(null);
                totalCacheEntity.setOutStoreTaxMoney(null);
                totalCacheEntity.setOtherMoney(null);
                totalCacheEntity.setOtherNum(null);
                totalCacheEntity.setOtherTaxMoney(null);
                totalCacheEntity.setOutOtherMoney(null);
                totalCacheEntity.setOutOtherTaxMoney(null);
                if (!CollectionUtils.isNotEmpty(itemEntityList) || !BooleanUtils.isFalse((Boolean)totalCacheEntity.getSelfScopeFlag()) && !DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(totalCacheEntity.getDocType())) break block2;
                for (DetailCacheEntity itemEntity : itemEntityList) {
                    totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanMoney(), (BigDecimal)itemEntity.getPlanMoney()));
                    totalCacheEntity.setPlanNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanNum(), (BigDecimal)itemEntity.getPlanNum()));
                    totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)itemEntity.getPlanTaxMoney()));
                    totalCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContMoney(), (BigDecimal)itemEntity.getContMoney()));
                    totalCacheEntity.setContNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContNum(), (BigDecimal)itemEntity.getContNum()));
                    totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)itemEntity.getContTaxMoney()));
                    totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreMoney(), (BigDecimal)itemEntity.getStoreMoney()));
                    totalCacheEntity.setStoreNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreNum(), (BigDecimal)itemEntity.getStoreNum()));
                    totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)itemEntity.getStoreTaxMoney()));
                    totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherMoney(), (BigDecimal)itemEntity.getOtherMoney()));
                    totalCacheEntity.setOtherNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherNum(), (BigDecimal)itemEntity.getOtherNum()));
                    totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)itemEntity.getOtherTaxMoney()));
                    if (null != itemEntity.getDutyItemId()) continue;
                    totalCacheEntity.setOutPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutPlanMoney(), (BigDecimal)itemEntity.getPlanMoney()));
                    totalCacheEntity.setOutPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutPlanTaxMoney(), (BigDecimal)itemEntity.getPlanTaxMoney()));
                    totalCacheEntity.setOutContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutContMoney(), (BigDecimal)itemEntity.getContMoney()));
                    totalCacheEntity.setOutContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutContTaxMoney(), (BigDecimal)itemEntity.getContTaxMoney()));
                    totalCacheEntity.setOutStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutStoreMoney(), (BigDecimal)itemEntity.getStoreMoney()));
                    totalCacheEntity.setOutStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutStoreTaxMoney(), (BigDecimal)itemEntity.getStoreTaxMoney()));
                    totalCacheEntity.setOutOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutOtherMoney(), (BigDecimal)itemEntity.getOtherMoney()));
                    totalCacheEntity.setOutOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutOtherTaxMoney(), (BigDecimal)itemEntity.getOtherTaxMoney()));
                }
                break block3;
            }
            if (!BooleanUtils.isTrue((Boolean)totalCacheEntity.getLeafFlag()) || !BooleanUtils.isTrue((Boolean)totalCacheEntity.getSelfScopeFlag())) break block3;
            List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(totalCacheEntity.getFeeDetailId());
            for (FeeDetailScopeEntity scopeEntity : scopeEntityList) {
                String key = scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue();
                if (!totalExecMap.containsKey(key)) continue;
                List<TotalExecutionEntity> totalExecutionEntities = totalExecMap.get(key);
                this.setValueByList(totalCacheEntity, totalExecutionEntities);
            }
        }
    }

    private Map<String, List<TotalExecutionEntity>> queryTotalExecMap() {
        HashMap<String, List<TotalExecutionEntity>> cacheMap = new HashMap<String, List<TotalExecutionEntity>>();
        LambdaQueryWrapper totalExecQry = new LambdaQueryWrapper();
        totalExecQry.eq(TotalExecutionEntity::getProjectId, (Object)this.dutyEntity.getProjectId());
        List totalExecEntities = this.totalExecutionService.list((Wrapper)totalExecQry);
        if (CollectionUtils.isNotEmpty((Collection)totalExecEntities)) {
            for (TotalExecutionEntity executionEntity : totalExecEntities) {
                String key = executionEntity.getBussinessType() + "&" + executionEntity.getProperty();
                List cacheEntityList = cacheMap.containsKey(key) ? (List)cacheMap.get(key) : new ArrayList();
                cacheEntityList.add(executionEntity);
                cacheMap.put(key, cacheEntityList);
            }
        }
        return cacheMap;
    }

    private Map<Long, List<DetailCacheEntity>> queryDetailCacheMap() {
        HashMap<Long, List<DetailCacheEntity>> cacheMap = new HashMap<Long, List<DetailCacheEntity>>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DetailCacheEntity::getProjectId, (Object)this.dutyEntity.getProjectId());
        List cacheEntities = this.detailCacheService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)cacheEntities)) {
            for (DetailCacheEntity cacheEntity : cacheEntities) {
                Long key = cacheEntity.getDutyDetailId();
                List cacheEntityList = cacheMap.containsKey(key) ? (List)cacheMap.get(key) : new ArrayList();
                cacheEntityList.add(cacheEntity);
                cacheMap.put(key, cacheEntityList);
            }
        }
        return cacheMap;
    }

    private Map<Long, List<FeeDetailScopeEntity>> queryScopeMap() {
        HashMap<Long, List<FeeDetailScopeEntity>> scopeMap = new HashMap<Long, List<FeeDetailScopeEntity>>();
        LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeId, (Object)this.dutyEntity.getFeeId());
        List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
        if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
            for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                Long key = scopeEntity.getFeeDetailId();
                List scopeEntityList = scopeMap.containsKey(key) ? (List)scopeMap.get(key) : new ArrayList();
                scopeEntityList.add(scopeEntity);
                scopeMap.put(key, scopeEntityList);
            }
        }
        return scopeMap;
    }

    private Map<Long, List<DutyDetailItemEntity>> queryAllItemMap() {
        HashMap<Long, List<DutyDetailItemEntity>> itemAllMap = new HashMap<Long, List<DutyDetailItemEntity>>();
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.eq(DutyDetailItemEntity::getDutyId, (Object)this.dutyEntity.getId());
        List itemEntityList = this.dutyDetailItemService.list((Wrapper)itemQuery);
        if (CollectionUtils.isNotEmpty((Collection)itemEntityList) && CollectionUtils.isNotEmpty((Collection)itemEntityList)) {
            for (DutyDetailItemEntity detailItemEntity : itemEntityList) {
                Long key = detailItemEntity.getDutyDetailId();
                List itemList = itemAllMap.containsKey(key) ? (List)itemAllMap.get(key) : new ArrayList();
                itemList.add(detailItemEntity);
                itemAllMap.put(key, itemList);
            }
        }
        return itemAllMap;
    }

    private void setDetailValue(DetailCacheEntity detailCacheEntity, DetailExecutionEntity detailExecutionEntity) {
        if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanMoney(), (BigDecimal)detailExecutionEntity.getMoney()));
            detailCacheEntity.setPlanNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanNum(), (BigDecimal)detailExecutionEntity.getNum()));
            detailCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanTaxMoney(), (BigDecimal)detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContMoney(), (BigDecimal)detailExecutionEntity.getMoney()));
            detailCacheEntity.setContNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContNum(), (BigDecimal)detailExecutionEntity.getNum()));
            detailCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContTaxMoney(), (BigDecimal)detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreMoney(), (BigDecimal)detailExecutionEntity.getMoney()));
            detailCacheEntity.setStoreNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreNum(), (BigDecimal)detailExecutionEntity.getNum()));
            detailCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreTaxMoney(), (BigDecimal)detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherMoney(), (BigDecimal)detailExecutionEntity.getMoney()));
            detailCacheEntity.setOtherNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherNum(), (BigDecimal)detailExecutionEntity.getNum()));
            detailCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherTaxMoney(), (BigDecimal)detailExecutionEntity.getTaxMoney()));
        }
    }
}

