package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.costplan.service.ITargetCostPlanService;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.DutyWarnVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("duty")
public class DutyBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IDutyService dutyService;

	@Autowired
	private IDutyDetailItemService dutyDetailItemService;


	@Autowired
	private ITotalExecutionService totalExecutionService;
	@Autowired
	private ITargetCostPlanService costPlanService;
	@Autowired
	private DutyMapper dutyMapper;
	@Autowired
	private IPushMessageApi pushMessageApi;
	static  String  PC_URL = "/ejc-targetcost-frontend/#/duty/card?id=";
	static  String  TEST_AGENTID = "1000038";
	static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
	static  String  PRO_AGENTID = "1000036";
	static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================提交前回调====================================== state:"+state);
		DutyEntity dutyEntity = dutyService.selectById(billId);
		LambdaQueryWrapper<DutyDetailItemEntity> query = new LambdaQueryWrapper<>();
		query.eq(DutyDetailItemEntity::getDutyId, billId);
		List<DutyDetailItemEntity> dutyDetailItemEntityList = dutyDetailItemService.list(query);
		for(DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList){
			if(dutyDetailItemEntity.getTaxRate() == null){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,税率必填！ ");

			}
			if(null != dutyEntity.getLastDutyId()){
				if(dutyDetailItemEntity.getAmount() == null){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,数量必填！");
				}
				if(dutyDetailItemEntity.getPrice() == null){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ "，单价(无税)必填！");

				}
				if(dutyDetailItemEntity.getTaxPrice() == null){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单价必填！");
				}
			}else{
				if (dutyEntity.getDutyVersion() == 1) {
					//只有第一版校验不允许为零，变更时数量可以为零
					if (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0) {
						throw new BusinessException("请检查右侧明细，名称【" + dutyDetailItemEntity.getName() + "】,数量必填且不能为零！");
					}
				}
				if(dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ "，单价(无税)必填且不能为零！");

				}
				if(dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单价必填且不能为零！");
				}
			}
			if(dutyDetailItemEntity.getUnitName() == null){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单位必填！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		DutyEntity dutyEntity = dutyService.selectById(billId);
		logger.info("state---------------有审批流的撤回前回调-------------------"+state);
		if (state == 0){ // 点击撤回进入流程，   驳回state传4，直接成功
			if(dutyEntity.getLastDutyId()==null) {
				if (BooleanUtils.isFalse(dutyEntity.getLatestFlag()) || (1 != dutyEntity.getDutyVersion() && BooleanUtils.isFalse(dutyEntity.getEnableState()))) {
					throw new BusinessException("非最新生效版本，不能撤回！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		totalExecutionService.reCalc(dutyService.selectById(billId).getProjectId());
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DutyEntity dutyEntity = dutyService.selectById(billId);
		logger.info("======================================终审审核前回调====================================== state:"+state);
		if(state == 0){
			LambdaQueryWrapper<DutyDetailItemEntity> query = new LambdaQueryWrapper<>();
			query.eq(DutyDetailItemEntity::getDutyId, billId);
			List<DutyDetailItemEntity> dutyDetailItemEntityList = dutyDetailItemService.list(query);
			for(DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList){
				if(dutyDetailItemEntity.getTaxRate() == null){//需求确认，税率不校验为0情况！
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,税率必填！ ");
				}
				if (dutyEntity.getDutyVersion() == 1) {
					//只有第一版校验不允许为零，变更时数量可以为零
					if (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0) {
						throw new BusinessException("请检查右侧明细，名称【" + dutyDetailItemEntity.getName() + "】,数量必填！");
					}
				}
				if(dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ "，单价(无税)必填！");

				}
				if(dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单价必填！");
				}
				if(dutyDetailItemEntity.getUnitName() == null){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单位必填！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//审核完成是否生效修改为是
		updateEnableAndWriteBack(billId, true);
		dutyService.gatherDuty(billId);
		DutyEntity dutyEntity = dutyService.selectById(billId);
		totalExecutionService.reCalc(dutyEntity.getProjectId());

		//修改目标月计划完成情况
		costPlanService.updateFinishStateTargetCost(dutyEntity.getProjectId(),dutyEntity.getId(),1);


		//预警消息，在施的项目，如果目标的利润率<5%提醒成本中心所有人，如果<=3%提醒到汪总，首席服务官，经营、工管、人力经理
		if (dutyEntity.getFloatRate().compareTo(new BigDecimal(5)) < 0){
			DutyWarnVO dutyWarnVO = dutyMapper.queryProjectById(dutyEntity.getProjectId());
			if (dutyWarnVO != null){
				List<String> strList = new ArrayList<>();
				if (dutyEntity.getFloatRate().compareTo(new BigDecimal(3)) <= 0){
					strList.add("1502571522403864577");//汪总
					strList.add(dutyWarnVO.getCostAdapter()+"");//首席服务官
					strList.add("1502571539046862850");//孙晓一测试
				}else {
					strList.add("1502571533065785345");//王慧敏
					strList.add("1502571556109291522");//段伟丹
					strList.add("1502571569002582018");//曾利霞
					strList.add("1502571569451372545");//崔琪
					strList.add("1502571573951860738");//冯群耀
					strList.add("1502571581195423746");//王亚琴
					strList.add("1502571588015362049");//梁丁
//					strList.add("1502571608466788354");//魏萌萌
					strList.add("1502571641173970946");//司克斌
					strList.add("1896437100327510018");//倪伦

				}

				if(CollectionUtils.isNotEmpty(strList)) {
					for (String s : strList) {
						sendSys(s, dutyEntity.getFloatRate(), dutyEntity.getProjectName(), dutyEntity.getId());
					}

				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("state---------------弃审前事件回调-------------------"+state);
		DutyEntity dutyEntity = dutyService.selectById(billId);
		if(!(dutyEntity.getEnableState() && dutyEntity.getLatestFlag())){
			throw new BusinessException("非最新生效版本，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		dutyService.gatherDuty(billId);
		DutyEntity dutyEntity = dutyService.selectById(billId);
		totalExecutionService.reCalc(dutyEntity.getProjectId());

		//修改目标月计划完成情况
		costPlanService.updateFinishStateTargetCost(dutyEntity.getProjectId(),dutyEntity.getId(),0);
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		DutyEntity dutyEntity = dutyService.getById(billId);
		dutyEntity.setEnableState(isPass);
		dutyService.saveOrUpdate(dutyEntity);
		//弃审,存在前版本，单据是否生效为是
		if(dutyEntity.getLastDutyId()!=null){
			DutyEntity revise = dutyService.getById(dutyEntity.getLastDutyId());
			revise.setChangeState(isPass ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(!isPass);
			dutyService.saveOrUpdate(revise);
		}
	}


	public boolean sendSys(String receiverId,BigDecimal floatRate,String projectName,Long id){

		PushMsgParameter parameter = new PushMsgParameter();
		List<String> channel = new ArrayList<>();
		channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
		channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
		String[] receivers = {receiverId};
		parameter.setReceivers(receivers);// 收信人
		parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
		parameter.setMsgType("earlywarning");//预警消息
		parameter.setSubject(projectName+"目标成本分解利润率为"+floatRate+"%");// 标题
		parameter.setContent("内容");// 内容
		parameter.setPcUrl(PC_URL+id);// pc端url
		parameter.setMobileUrl(PC_URL+id);// 移动端url
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setSendUserId(InvocationInfoProxy.getUserid());
		JSONObject weixineeParams = new JSONObject();
		weixineeParams.put("agentid",PRO_AGENTID);//企业微信应用id
		weixineeParams.put("secret", PRO_SECRET);//企业微信secret
		weixineeParams.put("msgtype", "textcard");
		weixineeParams.put("title", "目标成本利润率低提醒");
		weixineeParams.put("description", projectName+"目标成本分解利润率为"+floatRate+"%");
		weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
				"&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-targetcost-frontend%2f%23%2fduty%2fcard%3fid%3d"+id));//移动端点击的url
		weixineeParams.put("btntxt", "点击查看");
		parameter.setWeixineeParams(weixineeParams);

		CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
		if (result.isSuccess()) {
			logger.info("消息发送成功---------------->,接收人:{}", Arrays.toString(receivers));

			return true;
		} else {
			logger.error("消息发送失败---------------->" + result.getMsg());
			return false;
		}
	}
}
