/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IAssessDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.vo.AssessDetailVO;
import com.ejianc.business.targetcost.vo.DutyWarnVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dutyWarn/"})
public class DutyWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService service;
    @Autowired
    private IAssessDetailService assessDetailService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static String PC_URL_EC = "/ejc-targetcost-frontend/#/execution?projectId=";
    static String TEST_AGENTID = "1000038";
    static String TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static String PRO_AGENTID = "1000036";
    static String PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";
    static String PC_URL = "/ejc-targetcost-frontend/#/duty";

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 15;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<AssessDetailVO> assessDetailVOS = this.service.queryWarnList();
            if (!ListUtil.isNotEmpty(assessDetailVOS)) continue;
            for (AssessDetailVO assessDetailVO : assessDetailVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L <= (long)day.intValue() && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L >= 0L) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L <= (long)day.intValue() && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L >= 0L) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L > (long)day.intValue() || (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L < 0L) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getProjectName());
                vo.setPcTitle("\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                vo.setPcUrl(PC_URL + assessDetailVO.getParentId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getParentId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @PostMapping(value={"noDutyExecute"})
    public CommonResponse<String> noDutyExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<DutyWarnVO> dutyWarnVOS = this.service.queryProjectList();
            if (!ListUtil.isNotEmpty(dutyWarnVOS)) continue;
            for (DutyWarnVO assessDetailVO : dutyWarnVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    low = true;
                    useSetLow = set;
                    meddle = true;
                    useSetMeddle = set;
                    high = true;
                    useSetHigh = set;
                    if (!(assessDetailVO.getProjectType() != null && assessDetailVO.getProjectType().equals(1506581476628926466L) || assessDetailVO.getContractValuationType() != null && assessDetailVO.getContractValuationType().equals(1269824218831179778L))) {
                        if (assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 365 || assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*5")) >= 0) {
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                                low = true;
                                useSetLow = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 120L) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 150L) continue;
                            high = true;
                            useSetHigh = set;
                            continue;
                        }
                        if (assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 180 || assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*2")) >= 0) {
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 60L) {
                                low = true;
                                useSetLow = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 120L) continue;
                            high = true;
                            useSetHigh = set;
                            continue;
                        }
                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 30L) {
                            low = true;
                            useSetLow = set;
                        }
                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 60L) {
                            meddle = true;
                            useSetMeddle = set;
                        }
                        if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 90L) continue;
                        high = true;
                        useSetHigh = set;
                        continue;
                    }
                    if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                        low = true;
                        useSetLow = set;
                    }
                    if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 120L) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 150L) continue;
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u76ee\u6807\u8d23\u4efb\u6210\u672c\u672a\u7f16\u5236");
                vo.setPcUrl(PC_URL);
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getName());
                vo.setSourceId(assessDetailVO.getId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"queryExecution"})
    public CommonResponse<List<JSONObject>> queryExecution(HttpServletRequest request) {
        this.logger.info("\u6d88\u606f\u53d1\u9001\u524d1---------------->");
        List<DutyWarnVO> taskinstVOS = this.dutyMapper.queryExecution();
        this.logger.info("\u6d88\u606f\u53d1\u9001\u524d2---------------->{}", (Object)taskinstVOS.size());
        if (CollectionUtils.isNotEmpty(taskinstVOS)) {
            for (DutyWarnVO taskEntity : taskinstVOS) {
                this.sendSys(taskEntity.getCostAdapter() + "", taskEntity.getName(), taskEntity.getProjectName(), taskEntity.getProjectId());
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    public boolean sendSys(String receiverId, String name, String projectName, Long projectId) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("weixinee");
        channel.add("sys");
        Object[] receivers = new String[]{receiverId};
        parameter.setReceivers((String[])receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("earlywarning");
        parameter.setSubject(projectName + "\u9879\u76ee\u7269\u8d44\u6a21\u5757\u7684\uff08" + name + "\uff09\uff0c\u8d85\u51fa\u76ee\u6807\u6210\u672c");
        parameter.setContent("\u5185\u5bb9");
        parameter.setPcUrl(PC_URL_EC + projectId);
        parameter.setMobileUrl(PC_URL_EC + projectId);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", (Object)PRO_AGENTID);
        weixineeParams.put("secret", (Object)PRO_SECRET);
        weixineeParams.put("msgtype", (Object)"textcard");
        weixineeParams.put("title", (Object)"\u76ee\u6807\u6210\u672c\u8d85\u51fa\u63d0\u9192");
        weixineeParams.put("description", (Object)(projectName + "\u9879\u76ee\u7269\u8d44\u6a21\u5757\u7684\uff08" + name + "\uff09\uff0c\u8d85\u51fa\u76ee\u6807\u6210\u672c\u7684\u5bf9\u5e94\u8d39\u7528\u9879\u91d1\u989d\uff0c\u8bf7\u53ca\u65f6\u524d\u5f80\u7535\u8111\u7aef\u67e5\u770b\u6570\u636e\u6392\u67e5\u539f\u56e0\uff0c\u5982\u6709\u95ee\u9898\u53ca\u65f6\u4e0e\u9879\u76ee\u6c9f\u901a\u3002"));
        weixineeParams.put("url", (Object)("https://pms.zzyjjt.com/portal/sso/index?&userid=" + receiverId + "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-targetcost-frontend%2f%23%2fexecution%3fprojectId%3d%0a" + projectId));
        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
        parameter.setWeixineeParams(weixineeParams);
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->,\u63a5\u6536\u4eba:{}", (Object)Arrays.toString(receivers));
            return true;
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
        return false;
    }
}

