package com.ejianc.business.warn.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

public class WarningVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 编码
	 */
	private String code;

	/**
	 * 条件名称
	 */
	private String name;

	/**
	 * 所属组织
	 */
	private Long orgId;

	/**
	 * 状态
	 */
	private Integer state;

	/**
	 * 服务地址
	 */
	private String serviceAdress;

	/**
	 * 描述
	 */
	private String description;

	/**
	 * 单据类型（预警分类）
	 */
	private Long moduleId;

	/**
	 * 预警分类名称
	 */
	private String moduleName;

	private Integer dispatchType; // 1:预警任务/2:普通调度任务

	/**
	 * 预警接收对象
	 */
	private List<WarningReceiveVO> warningReceiveList = new ArrayList<>();

	/**
	 * 预警条件参数
	 */
	private List<WarningParameterVO> warningParameterList = new ArrayList<>();

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getOrgId() {
		return orgId;
	}

	@ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getServiceAdress() {
		return serviceAdress;
	}

	public void setServiceAdress(String serviceAdress) {
		this.serviceAdress = serviceAdress;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<WarningReceiveVO> getWarningReceiveList() {
		return warningReceiveList;
	}

	public void setWarningReceiveList(List<WarningReceiveVO> warningReceiveList) {
		this.warningReceiveList = warningReceiveList;
	}

	public List<WarningParameterVO> getWarningParameterList() {
		return warningParameterList;
	}

	public void setWarningParameterList(List<WarningParameterVO> warningParameterList) {
		this.warningParameterList = warningParameterList;
	}

	public Integer getDispatchType() {
		return dispatchType;
	}

	public void setDispatchType(Integer dispatchType) {
		this.dispatchType = dispatchType;
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getModuleName() {
		return moduleName;
	}

	public void setModuleName(String moduleName) {
		this.moduleName = moduleName;
	}
}
