package com.ejianc.business.center.api;

import com.ejianc.business.center.hystrix.IWarnCenterHystrix;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2021/1/21  预警中心
 * @Description IWarnCenterApi
 */

@FeignClient(name= "ejc-task-web", url="${common.env.feign-client-url}", path="ejc-task-web", fallback = IWarnCenterHystrix.class)
public interface IWarnCenterApi {

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/21
	 * @Description sendToWarnCenter 将预警内容发送至预警中心
	 * @Param warnTransVO 具体参数，请点击查看该类详情说明
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/warnCenter/sendToWarnCenter", method=RequestMethod.POST)
	CommonResponse<String> sendToWarnCenter(@RequestBody List<EarlyWarnTransVO> warnTransVO, @RequestParam(value = "warnSetId") Long warnSetId);
}
