package com.ejianc.business.warn.api;

import com.ejianc.business.warn.hystrix.WarnSettingHystrix;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/1/26 14:40
 */
@FeignClient(name= "ejc-task-web", url="${common.env.feign-client-url}", path="ejc-task-web", fallback = WarnSettingHystrix.class)
public interface IWarnSettingApi {

    /**
     * 根据预警设置主题Id查询所有对应的用户自定义预警设置信息列表
     *
     * @param warnId 预警设置主题Id
     * @return
     */
    @GetMapping(value = "/api/warnSetting/no_auth/getCustomWarnListByWarnId")
    public CommonResponse<List<CustomWarnSettingVO>> getCustomWarnListByWarnId(@RequestParam(value = "warnId") Long warnId);

}
