package com.ejianc.business.task.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 任务bean
 * 
 * @author liyongjia
 */
public class TaskVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	private String code; // 任务编码

	private String assignUserName; // 指派用户

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date taskDuration; // 任务期限

	private String taskLevel; // 任务等级

	private String taskState; // 任务状态

	private String taskDescribe; // 任务描述

	private String taskName; // 预警名称

	private String taskType; // 任务类型（earlywarn:预警等）
	
	private Long orgId; // 所属组织ID

	private String orgName; // 所属组织

	private String taskPcUrl; // 任务链接pcurl（绑定task_name跳转链接）

	private String taskMaUrl; // 任务链接maurl（绑定task_name跳转链接）

	private Long promoterId; // 发起人

	private String promoterName; // 发起人

	private String solution; // 解决方案
	
	private List<TaskHistoryVO> historyList = new ArrayList<>();
	
	private List<TaskReceiverVO> receiverList = new ArrayList<>();

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getAssignUserName() {
		return assignUserName;
	}

	public void setAssignUserName(String assignUserName) {
		this.assignUserName = assignUserName;
	}

	public Date getTaskDuration() {
		return taskDuration;
	}

	public void setTaskDuration(Date taskDuration) {
		this.taskDuration = taskDuration;
	}

	public String getTaskLevel() {
		return taskLevel;
	}

	public void setTaskLevel(String taskLevel) {
		this.taskLevel = taskLevel;
	}

	public String getTaskState() {
		return taskState;
	}

	public void setTaskState(String taskState) {
		this.taskState = taskState;
	}

	public String getTaskDescribe() {
		return taskDescribe;
	}

	public void setTaskDescribe(String taskDescribe) {
		this.taskDescribe = taskDescribe;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getTaskType() {
		return taskType;
	}

	public void setTaskType(String taskType) {
		this.taskType = taskType;
	}

	public String getTaskPcUrl() {
		return taskPcUrl;
	}

	public void setTaskPcUrl(String taskPcUrl) {
		this.taskPcUrl = taskPcUrl;
	}

	public String getTaskMaUrl() {
		return taskMaUrl;
	}

	public void setTaskMaUrl(String taskMaUrl) {
		this.taskMaUrl = taskMaUrl;
	}

	public Long getPromoterId() {
		return promoterId;
	}

	public void setPromoterId(Long promoterId) {
		this.promoterId = promoterId;
	}

	public String getPromoterName() {
		return promoterName;
	}

	public void setPromoterName(String promoterName) {
		this.promoterName = promoterName;
	}

	public String getSolution() {
		return solution;
	}

	public void setSolution(String solution) {
		this.solution = solution;
	}

	public List<TaskHistoryVO> getHistoryList() {
		return historyList;
	}

	public void setHistoryList(List<TaskHistoryVO> historyList) {
		this.historyList = historyList;
	}

	public List<TaskReceiverVO> getReceiverList() {
		return receiverList;
	}

	public void setReceiverList(List<TaskReceiverVO> receiverList) {
		this.receiverList = receiverList;
	}
	
}
