package com.ejianc.business.supervision.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 *
 *
 * @author CJ
 * @Description:
 * @date 2021/6/17 13:44
 */
public class SupervisionSubVO extends BaseVO {
    public static final Integer OVERDUE_FLAG_TRUE = 1;
    public static final Integer OVERDUE_FLAG_FALSE = 0;
    private static final long serialVersionUID = -3455383561250967998L;

    /**
     * 所属督办Id
     */
    private Long supervisionId;

    /**
     * 协调事项描述
     */
    private String itemDesc;

    /**
     * 反馈周期：每周-week, 每月-month
     */
    private String feedbackCyc;

    /**
     * 预计完成日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date itemEstimatedFinishDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 负责人Id
     */
    private Long responsibleUserId;

    /**
     * 负责人名称
     */
    private String responsibleUserName;

    /**
     * 处理状态：running-进行中，finish-已完成，close-已关闭
     */
    private String handleState;

    /**
     * 对应任务Id
     */
    private Long taskId;

    /**
     * 预期标识：0-未逾期，1-已逾期
     */
    private Integer overdueFlag;

    public Long getSupervisionId() {
        return supervisionId;
    }

    public void setSupervisionId(Long supervisionId) {
        this.supervisionId = supervisionId;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getFeedbackCyc() {
        return feedbackCyc;
    }

    public void setFeedbackCyc(String feedbackCyc) {
        this.feedbackCyc = feedbackCyc;
    }

    public Date getItemEstimatedFinishDate() {
        return itemEstimatedFinishDate;
    }

    public void setItemEstimatedFinishDate(Date itemEstimatedFinishDate) {
        this.itemEstimatedFinishDate = itemEstimatedFinishDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getResponsibleUserId() {
        return responsibleUserId;
    }

    public void setResponsibleUserId(Long responsibleUserId) {
        this.responsibleUserId = responsibleUserId;
    }

    public String getResponsibleUserName() {
        return responsibleUserName;
    }

    public void setResponsibleUserName(String responsibleUserName) {
        this.responsibleUserName = responsibleUserName;
    }

    public String getHandleState() {
        return handleState;
    }

    public void setHandleState(String handleState) {
        this.handleState = handleState;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Integer getOverdueFlag() {
        return overdueFlag;
    }

    public void setOverdueFlag(Integer overdueFlag) {
        this.overdueFlag = overdueFlag;
    }
}
