package com.ejianc.business.supervision.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/6/17 13:49
 */
public class SupervisionVO extends BaseVO {
    private static final long serialVersionUID = -2512047557361608850L;

    public static final Integer SUPERVISION_STATE_HANDLING = 0;
    public static final Integer SUPERVISION_STATE_FINISHED = 1;

    /**
     * 督办标题
     */
    private String title;

    /**
     * 督办编号
     */
    private String billCode;

    /**
     * 发起人Id
     */
    private Long initiatorId;

    /**
     * 发起人名称
     */
    private String initiatorName;

    /**
     * 发起人所属组织Id
     */
    private Long initiatorOrgId;

    /**
     * 发起人所属组织名称
     */
    private String initiatorOrgName;

    /**
     * 发起时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date initiateTime;

    /**
     * 责任人
     */
    private Long responsibleUserId;

    /**
     * 责任人名称
     */
    private String responsibleUserName;

    /**
     * 责任人所属组织Id
     */
    private Long responsibleUserOrgId;

    /**
     * 责任人所属组织名称
     */
    private String responsibleUserOrgName;

    /**
     * 预计完成日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date estimatedFinishDate;

    /**
     * 督办任务项列表
     */
    private List<SupervisionSubVO> supervisionItemList;

    /**
     * 总任务项数量
     */
    private Integer totalItemNum;
    /**
     * 已完成数量
     */
    private Integer finishItemNum;
    /**
     * 逾期项数量
     */
    private Integer overdueItemNum;

    /**
     * 督办状态：0-进行中，1-已完成
     */
    private Integer status;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    @ReferDeserialTransfer
    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public Long getInitiatorOrgId() {
        return initiatorOrgId;
    }

    @ReferDeserialTransfer
    public void setInitiatorOrgId(Long initiatorOrgId) {
        this.initiatorOrgId = initiatorOrgId;
    }

    public String getInitiatorOrgName() {
        return initiatorOrgName;
    }

    public void setInitiatorOrgName(String initiatorOrgName) {
        this.initiatorOrgName = initiatorOrgName;
    }

    public Date getInitiateTime() {
        return initiateTime;
    }

    public void setInitiateTime(Date initiateTime) {
        this.initiateTime = initiateTime;
    }

    public Long getResponsibleUserId() {
        return responsibleUserId;
    }

    @ReferDeserialTransfer
    public void setResponsibleUserId(Long responsibleUserId) {
        this.responsibleUserId = responsibleUserId;
    }

    public String getResponsibleUserName() {
        return responsibleUserName;
    }

    public void setResponsibleUserName(String responsibleUserName) {
        this.responsibleUserName = responsibleUserName;
    }

    public Long getResponsibleUserOrgId() {
        return responsibleUserOrgId;
    }

    @ReferDeserialTransfer
    public void setResponsibleUserOrgId(Long responsibleUserOrgId) {
        this.responsibleUserOrgId = responsibleUserOrgId;
    }

    public String getResponsibleUserOrgName() {
        return responsibleUserOrgName;
    }

    public void setResponsibleUserOrgName(String responsibleUserOrgName) {
        this.responsibleUserOrgName = responsibleUserOrgName;
    }

    public Date getEstimatedFinishDate() {
        return estimatedFinishDate;
    }

    public void setEstimatedFinishDate(Date estimatedFinishDate) {
        this.estimatedFinishDate = estimatedFinishDate;
    }

    public List<SupervisionSubVO> getSupervisionItemList() {
        return supervisionItemList;
    }

    public void setSupervisionItemList(List<SupervisionSubVO> supervisionItemList) {
        this.supervisionItemList = supervisionItemList;
    }

    public Integer getTotalItemNum() {
        return totalItemNum;
    }

    public void setTotalItemNum(Integer totalItemNum) {
        this.totalItemNum = totalItemNum;
    }

    public Integer getFinishItemNum() {
        return finishItemNum;
    }

    public void setFinishItemNum(Integer finishItemNum) {
        this.finishItemNum = finishItemNum;
    }

    public Integer getOverdueItemNum() {
        return overdueItemNum;
    }

    public void setOverdueItemNum(Integer overdueItemNum) {
        this.overdueItemNum = overdueItemNum;
    }
}
