package com.ejianc.business.supervision.api;

import com.ejianc.business.supervision.hystrix.SupervisionHystrix;
import com.ejianc.business.supervision.vo.SupervisionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/6/23 13:58
 */
@FeignClient(name= "ejc-task-web", url="${common.env.feign-client-url}", path="ejc-task-web", fallback = SupervisionHystrix.class)
public interface ISupervisionApi {

    /**
     * 查询指定组织本下生效未完成的督办列表
     *
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/api/supervision/queryRunningList", method= RequestMethod.GET)
    public CommonResponse<List<SupervisionVO>> queryRunningList(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "searchText", required = false) String searchText);

}
