package com.ejianc.business.warn.vo;

import com.ejianc.framework.skeleton.template.BaseTreeVO;

public class WarningParameterVO extends BaseTreeVO<WarningParameterVO> {

	private static final long serialVersionUID = 1L;

	/**
	 * 预警参数状态： 启用
	 */
	public static final String WARN_PARAM_STATE_ENABLE = "1";

	/**
	 * 预警参数状态：停用
	 */
	public static final String WARN_PARAM_STATE_DIENABLE = "0";

	/**
	 * 条件类型-简单单个条件
	 */
	public static final String CONDITION_TYPE_SIMPLE = "0";
	/**
	 * 条件类型-复合条件的前缀条件
	 */
	public static final String CONDITION_TYPE_COMPLEX_PREFIX = "1";
	/**
	 * 条件类型-复合条件的子条件
	 */
	public static final String CONDITION_TYPE_COMPLEX_CHILD = "2";

	/**
	 * 条件逻辑-且
	 */
	public static final String CONDITION_LOGIC_AND = "and";
	/**
	 * 条件逻辑-或
	 */
	public static final String CONDITION_LOGIC_OR = "or";

	/**
     * 参数类型
     */
    private String parameterType;
	
	/**
     * 参数名称
     */
    private String parameterName;
	
	/**
     * 主表键值
     */
    private Long warningId;
	
	/**
     * 参数条件
     */
    private String parameterCondition;
	
	/**
     * 参数值
     */
    private String parameterValue;
	
	/**
     * 参数单位
     */
    private String parameterUnit;
	
	/**
     * 参数属性
     */
    private String parameterProperty;

	/**
	 * 参数启用状态：0-停用，1-启用
	 */
	private String enableState;

	/**
	 * 父级条件Id
	 */
	private Long pid;

	/**
	 * 条件类型：0-普通单个条件（默认），1-复杂条件-前置条件，2：复杂条件-子条件
	 */
	private String conditionType;

	/**
	 * 条件匹配逻辑：and(且） / or(或)， 默认为and
	 */
	private String conditionLogic;

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public String getConditionType() {
		return conditionType;
	}

	public void setConditionType(String conditionType) {
		this.conditionType = conditionType;
	}

	public String getConditionLogic() {
		return conditionLogic;
	}

	public void setConditionLogic(String conditionLogic) {
		this.conditionLogic = conditionLogic;
	}

	public String getParameterType() {
		return parameterType;
	}

	public void setParameterType(String parameterType) {
		this.parameterType = parameterType;
	}

	public String getParameterName() {
		return parameterName;
	}

	public void setParameterName(String parameterName) {
		this.parameterName = parameterName;
	}

	public Long getWarningId() {
		return warningId;
	}

	public void setWarningId(Long warningId) {
		this.warningId = warningId;
	}

	public String getParameterCondition() {
		return parameterCondition;
	}

	public void setParameterCondition(String parameterCondition) {
		this.parameterCondition = parameterCondition;
	}

	public String getParameterValue() {
		return parameterValue;
	}

	public void setParameterValue(String parameterValue) {
		this.parameterValue = parameterValue;
	}

	public String getParameterUnit() {
		return parameterUnit;
	}

	public void setParameterUnit(String parameterUnit) {
		this.parameterUnit = parameterUnit;
	}

	public String getParameterProperty() {
		return parameterProperty;
	}

	public void setParameterProperty(String parameterProperty) {
		this.parameterProperty = parameterProperty;
	}

	public String getEnableState() {
		return enableState;
	}

	public void setEnableState(String enableState) {
		this.enableState = enableState;
	}
}
