package com.ejianc.business.center.api;

import com.ejianc.business.center.hystrix.IWarnCenterHystrix;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.center.vo.EarlyWarnVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2021/1/21  预警中心
 * @Description IWarnCenterApi
 */

@FeignClient(name= "ejc-task-web", url="${common.env.feign-client-url}", path="ejc-task-web", fallback = IWarnCenterHystrix.class)
public interface IWarnCenterApi {

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/21
	 * @Description sendToWarnCenter 将预警内容发送至预警中心
	 * @Param warnTransVO 具体参数，请点击查看该类详情说明
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/warnCenter/sendToWarnCenter", method=RequestMethod.POST)
	CommonResponse<String> sendToWarnCenter(@RequestBody List<EarlyWarnTransVO> warnTransVO, @RequestParam(value = "warnSetId") Long warnSetId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2022/8/6
	 * @Description sendToWarnCenterByCode 将预警内容发送至预警中心
	 * @Param warnTransVO 具体参数，请点击查看该类详情说明
	 * @Param code 预警参数编码，同一类预警，编码相同
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/warnCenter/sendToWarnCenterByCode", method=RequestMethod.POST)
	CommonResponse<String> sendToWarnCenterByCode(@RequestBody List<EarlyWarnTransVO> warnTransVO, @RequestParam(value = "code") String code);

	/**
	 * @Author mrsir_wxp
	 * @Date 2022/8/6
	 * @Description getWarnSet 业务触发预警,获取预警配置
	 * @Param code 预警参数编码，同一类预警，编码相同
	 * @Param orgId 预警参数设置的组织
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/warnCenter/getWarnSet", method=RequestMethod.GET)
	CommonResponse<WarningDTO> getWarnSet(@RequestParam(value = "code") String code, @RequestParam(value = "orgId") Long orgId);

	/**
	 * @Author zhangwx
	 * @Date 2022/05/28
	 * @Description sendToWarnCenterWithReceive 将预警内容发送至预警中心(带接收者信息)
	 * @Param warnTransVO 具体参数，请点击查看该类详情说明
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/warnCenter/sendToWarnCenterWithReceive", method=RequestMethod.POST)
	CommonResponse<String> sendToWarnCenterWithReceive(@RequestBody List<EarlyWarnTransVO> warnTransVO, @RequestParam(value = "warnSetId") Long warnSetId);

	/**
	 * 发送消息（微信公众号消息）
	 *
	 * @return
	 */
	@RequestMapping(value = "/api/warnCenter/sendMessage", method=RequestMethod.POST)
	CommonResponse<String> sendMessage();

	/**
	 * 根据项目部id查询该项目部风险数量
	 *
	 * @return
	 */
	@RequestMapping(value = "/api/warnCenter/queryProjectWarnNumByOrgId", method=RequestMethod.GET)
	CommonResponse<Integer> queryProjectWarnNumByOrgId(@RequestParam(value = "orgId") Long orgId);

	/**
	 * 根据项目部id查询该项目部风险列表
	 *
	 * @return
	 */
	@RequestMapping(value = "/api/warnCenter/queryProjectWarnListByOrgId", method=RequestMethod.GET)
	CommonResponse<List<EarlyWarnVO>> queryProjectWarnListByOrgId(@RequestParam(value = "orgId") Long orgId);
}
