package com.ejianc.business.center.vo;


import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 预警中心
 * 
 * @author generator
 * 
 */
public class EarlyWarnVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 所属组织id
    private String sourceId; // 预警对象ID
    private String earlywarnName; // 预警名称
    private String billName; // 预警单据名称
    private String earlywarnContent; // 预警内容
    private Integer state; // 状态（1：待督办，2：已忽略）
    private Integer normal; // 是否恢复正常，0否，1是
    private Long warnSetId; // 对应预警设置id
    private String warnSetTypeName; // 对应预警设置分类名称
    private String warnSetTypeId; // 对应预警设置分类Id
    private String pcUrl; // 穿透链接 pc端
    private String pcTitle; // 穿透页签名称 pc端
    private String moUrl; // 穿透链接 移动端
    private String warnLevel; // 风险等级
    private String orgName; // 所属组织名称
    private String ignoreReason; // 忽略理由
    private String ignorePerson; // 忽略操作人
    @JsonFormat( shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8" )
    private Date ignoreTime; // 忽略操作时间
    private String uniqueKey; // 唯一键（更新使用）

    private String receiveNames; // 预警接收人名称 xx,xc 等y人
    private String taskIds; // 预警任务id  以,分割
    @JsonFormat( shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8" )
    private Date warnUpdateTime; // 预警更新时间
    /**
     * 创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createTime;

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 预警对象ID
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 预警对象ID
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 预警名称
     */
    public String getEarlywarnName() {
        return earlywarnName;
    }

    /**
     * 预警名称
     */
    public void setEarlywarnName(String earlywarnName) {
        this.earlywarnName = earlywarnName;
    }
    /**
     * 预警单据名称
     */
    public String getBillName() {
        return billName;
    }

    /**
     * 预警单据名称
     */
    public void setBillName(String billName) {
        this.billName = billName;
    }
    /**
     * 预警内容
     */
    public String getEarlywarnContent() {
        return earlywarnContent;
    }

    /**
     * 预警内容
     */
    public void setEarlywarnContent(String earlywarnContent) {
        this.earlywarnContent = earlywarnContent;
    }
    /**
     * 状态（1：待督办，2：已忽略）
     */
    public Integer getState() {
        return state;
    }

    /**
     * 状态（1：待督办，2：已忽略）
     */
    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getNormal() {
        return normal;
    }

    public void setNormal(Integer normal) {
        this.normal = normal;
    }

    public String getReceiveNames() {
        return receiveNames;
    }

    public void setReceiveNames(String receiveNames) {
        this.receiveNames = receiveNames;
    }

    public String getTaskIds() {
        return taskIds;
    }

    public void setTaskIds(String taskIds) {
        this.taskIds = taskIds;
    }

    /**
     * 对应预警设置id
     */
    public Long getWarnSetId() {
        return warnSetId;
    }

    /**
     * 对应预警设置id
     */
    public void setWarnSetId(Long warnSetId) {
        this.warnSetId = warnSetId;
    }

    public String getPcUrl() {
        return pcUrl;
    }

    public void setPcUrl(String pcUrl) {
        this.pcUrl = pcUrl;
    }

    public String getPcTitle() {
        return pcTitle;
    }

    public void setPcTitle(String pcTitle) {
        this.pcTitle = pcTitle;
    }

    public String getMoUrl() {
        return moUrl;
    }

    public void setMoUrl(String moUrl) {
        this.moUrl = moUrl;
    }

    /**
     * 风险等级
     */
    public String getWarnLevel() {
        return warnLevel;
    }

    /**
     * 风险等级
     */
    public void setWarnLevel(String warnLevel) {
        this.warnLevel = warnLevel;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 忽略理由
     */
    public String getIgnoreReason() {
        return ignoreReason;
    }

    /**
     * 忽略理由
     */
    public void setIgnoreReason(String ignoreReason) {
        this.ignoreReason = ignoreReason;
    }
    /**
     * 忽略操作人
     */
    public String getIgnorePerson() {
        return ignorePerson;
    }

    /**
     * 忽略操作人
     */
    public void setIgnorePerson(String ignorePerson) {
        this.ignorePerson = ignorePerson;
    }
    /**
     * 忽略操作时间
     */
    public Date getIgnoreTime() {
        return ignoreTime;
    }

    /**
     * 忽略操作时间
     */
    public void setIgnoreTime(Date ignoreTime) {
        this.ignoreTime = ignoreTime;
    }
    /**
     * 唯一键（更新使用）
     */
    public String getUniqueKey() {
        return uniqueKey;
    }

    /**
     * 唯一键（更新使用）
     */
    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public Date getWarnUpdateTime() {
        return warnUpdateTime;
    }

    public void setWarnUpdateTime(Date warnUpdateTime) {
        this.warnUpdateTime = warnUpdateTime;
    }

    public String getWarnSetTypeName() {
        return warnSetTypeName;
    }

    public void setWarnSetTypeName(String warnSetTypeName) {
        this.warnSetTypeName = warnSetTypeName;
    }

    public String getWarnSetTypeId() {
        return warnSetTypeId;
    }

    public void setWarnSetTypeId(String warnSetTypeId) {
        this.warnSetTypeId = warnSetTypeId;
    }
}
