package com.ejianc.business.warn.vo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

public class WarningReceiveVO extends BaseVO {

	private static final long serialVersionUID = 1L;
	
	/**
     * 类型
     */
    private String type;

	/**
     * 类型
     */
    private String name;

	/**
     * 名称
     */
    private Long nameId;
	
	/**
     * 主表键值
     */
    private Long warningId;
	
	/**
     * 排序
     */
    private Integer sequence;

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getName() {
		if(StringUtils.isNotBlank(name)){
			return name;
		}
		try {
			if(this.type.equals("org")){
				if(nameId!=null){
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(nameId.toString(), "idm-org");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						return json.getString("name");
					}
				}
			}else if(this.type.equals("user")){
				if(nameId!=null){
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(nameId.toString(), "idm-user");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						return json.getString("name");
					}
				}
			}else if(this.type.equals("role")){
				if(nameId!=null){
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(nameId.toString(), "idm-role");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						return json.getString("name");
					}
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getNameId() {
		return nameId;
	}

	public void setNameId(Long nameId) {
		this.nameId = nameId;
	}

	public Long getWarningId() {
		return warningId;
	}

	public void setWarningId(Long warningId) {
		this.warningId = warningId;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}
    
}
