package com.ejianc.business.warn.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

public class WarningVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 预警等级 低
	 */
	public static final  String WARN_LEVEL_LOW = "低";
	/**
	 * 预警等级 中
	 */
	public static final  String WARN_LEVEL_MIDDLE = "中";
	/**
	 * 预警等级 高
	 */
	public static final  String WARN_LEVEL_HIGH = "高";

	/**
	 * 预警状态： 启用
	 */
	public static final Integer WARN_STATE_ENABLE = 1;

	/**
	 * 预警状态：停用
	 */
	public static final Integer WARN_STATE_DIENABLE = 0;

	/**
	 * 编码
	 */
	private String code;

	/**
	 * 条件名称
	 */
	private String name;

	/**
	 * 所属组织
	 */
	private Long orgId;

	/**
	 * 状态
	 */
	private Integer state;

	/**
	 * 服务地址
	 */
	private String serviceAdress;

	/**
	 * 预警内容模板
	 */
	private String warningContentTemplate;

	/**
	 * 描述
	 */
	private String description;

	/**
	 * 单据类型（预警分类）
	 */
	private Long moduleId;

	/**
	 * 预警分类名称
	 */
	private String moduleName;

	private Integer dispatchType; // 1:预警任务/2:普通调度任务

	/**
	 * 预警等级
	 */
	private String warningLevel;

	/**
	 * 预警接收对象
	 */
	private List<WarningReceiveVO> warningReceiveList = new ArrayList<>();

	/**
	 * 预警条件参数
	 */
	private List<WarningParameterVO> warningParameterList = new ArrayList<>();

	/**
	 * 接收对象列表
	 */
	private String receiverNames;


	/**
	 * 客户参数
	 */
	private List<CustomWarnSettingVO> warningSetings = new ArrayList<>();

	/**
	 * 预警任务-触发方式
	 * 1、调度触发
	 * 2、业务触发
	 */
	private Integer startType;

	/**
	 * 预警类型
	 * 1、普通预警
	 * 2、预警消息
	 */
	private Integer warnType;

	/**
	 * 是否系统初始设置，客户复制的都是：否
	 */
	private Boolean systemDefault;

	public List<CustomWarnSettingVO> getWarningSetings() {
		return warningSetings;
	}

	public void setWarningSetings(List<CustomWarnSettingVO> warningSetings) {
		this.warningSetings = warningSetings;
	}

	public Boolean getSystemDefault() {
		return systemDefault;
	}

	public void setSystemDefault(Boolean systemDefault) {
		this.systemDefault = systemDefault;
	}

	public String getReceiverNames() {
		return receiverNames;
	}

	public void setReceiverNames(String receiverNames) {
		this.receiverNames = receiverNames;
	}

	public Integer getStartType() {
		return startType;
	}

	public void setStartType(Integer startType) {
		this.startType = startType;
	}

	public Integer getWarnType() {
		return warnType;
	}

	public void setWarnType(Integer warnType) {
		this.warnType = warnType;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getOrgId() {
		return orgId;
	}

	@ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getServiceAdress() {
		return serviceAdress;
	}

	public void setServiceAdress(String serviceAdress) {
		this.serviceAdress = serviceAdress;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<WarningReceiveVO> getWarningReceiveList() {
		return warningReceiveList;
	}

	public void setWarningReceiveList(List<WarningReceiveVO> warningReceiveList) {
		this.warningReceiveList = warningReceiveList;
	}

	public List<WarningParameterVO> getWarningParameterList() {
		return warningParameterList;
	}

	public void setWarningParameterList(List<WarningParameterVO> warningParameterList) {
		this.warningParameterList = warningParameterList;
	}

	public Integer getDispatchType() {
		return dispatchType;
	}

	public void setDispatchType(Integer dispatchType) {
		this.dispatchType = dispatchType;
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getModuleName() {
		return moduleName;
	}

	public void setModuleName(String moduleName) {
		this.moduleName = moduleName;
	}

	public String getWarningLevel() {
		return warningLevel;
	}

	public void setWarningLevel(String warningLevel) {
		this.warningLevel = warningLevel;
	}

	public String getWarningContentTemplate() {
		return warningContentTemplate;
	}

	public void setWarningContentTemplate(String warningContentTemplate) {
		this.warningContentTemplate = warningContentTemplate;
	}
}
