package com.ejianc.business.center.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.center.vo.EarlyWarnVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class IWarnCenterHystrix implements IWarnCenterApi {

    /**
     * @Author mrsir_wxp
     * @Date 2021/1/21
     * @Description sendToWarnCenter 将预警内容发送至预警中心
     * @Param warnTransVO 具体参数，请点击查看该类详情说明
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<String> sendToWarnCenter(List<EarlyWarnTransVO> warnTransVO,Long warnSetId) {
        return CommonResponse.error("网络问题， 发送失败。");
    }

    /**
     * @param warnTransVO
     * @param code
     * @Author mrsir_wxp
     * @Date 2022/8/6
     * @Description sendToWarnCenter 将预警内容发送至预警中心
     * @Param warnTransVO 具体参数，请点击查看该类详情说明
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<String> sendToWarnCenterByCode(List<EarlyWarnTransVO> warnTransVO, String code) {
        return CommonResponse.error("网络问题， 发送失败。");
    }

    /**
     * @param code
     * @Author mrsir_wxp
     * @Date 2022/8/6
     * @Description getWarnSet 业务触发预警
     * @Param code 预警参数编码，同一类预警，编码相同
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<WarningDTO> getWarnSet(String code, Long orgId) {
        return CommonResponse.error("网络问题， 触发失败。");
    }

    @Override
    public CommonResponse<String> sendToWarnCenterWithReceive(List<EarlyWarnTransVO> warnTransVO, Long warnSetId) {
        return CommonResponse.error("网络问题， 发送失败。");
    }

    @Override
	public CommonResponse<String> sendMessage() {
		return CommonResponse.error("网络问题， 发送失败。");
	}

    /**
     * 根据项目部id查询该项目部风险数量
     *
     * @param orgId
     * @return
     */
    @Override
    public CommonResponse<Integer> queryProjectWarnNumByOrgId(Long orgId) {
        return CommonResponse.error("网络问题， 发送失败。");
    }

    /**
     * 根据项目部id查询该项目部风险列表
     *
     * @param orgId
     * @return
     */
    @Override
    public CommonResponse<List<EarlyWarnVO>> queryProjectWarnListByOrgId(Long orgId) {
        return CommonResponse.error("网络问题， 发送失败。");
    }

    /**
     * 根据项目部id查询该项目部风险数量
     * JSONObject格式：
     * {
     * "orgId1": "风险数量",
     * "orgId2": "风险数量",
     * }
     *
     * @param orgIds
     */
    @Override
    public CommonResponse<JSONObject> queryWarnNumByOrgIds(List<Long> orgIds) {
        return CommonResponse.error("网络问题， 发送失败。");
    }
}
