package com.ejianc.business.task.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务bean
 * 
 * @author liyongjia
 */
public class TaskVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 任务类型：督办任务
	 */
	public static final String TASK_TYPE_SUPERVISION = "supervision";
	public static final String TASK_TYPE_CONTACT_BILL = "contactBill";

	public static final String TASK_STATE_RUNNING = "running";
	public static final String TASK_STATE_CLOSE = "close";
	public static final String TASK_STATE_FINISH = "finish";

	private String code; // 任务编码

	private String assignUserName; // 指派用户

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date taskDuration; // 任务期限

	private String taskLevel; // 任务等级

	private String taskState; // 任务状态

	private String taskDescribe; // 任务描述

	private String taskName; // 预警名称

	private String taskType; // 任务类型（earlywarn:预警等）
	
	private Long orgId; // 所属组织ID

	private String orgName; // 所属组织

	private String taskPcUrl; // 任务链接pcurl（绑定task_name跳转链接）

	private String taskMaUrl; // 任务链接maurl（绑定task_name跳转链接）

	private Long promoterId; // 发起人

	private String promoterName; // 发起人

	private String solution; // 解决方案

	private Long responsibleUserId; // 负责人Id

	private String responsibleUserName; // 负责人名称

	private String assignUserId; // 指派用户Id

	/**
	 * 发起时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date initiateTime;
	
	private List<TaskHistoryVO> historyList = new ArrayList<>();
	
	private List<TaskReceiverVO> receiverList = new ArrayList<>();

	public Long getResponsibleUserId() {
		return responsibleUserId;
	}

	public void setResponsibleUserId(Long responsibleUserId) {
		this.responsibleUserId = responsibleUserId;
	}

	public String getResponsibleUserName() {
		return responsibleUserName;
	}

	public void setResponsibleUserName(String responsibleUserName) {
		this.responsibleUserName = responsibleUserName;
	}

	public String getAssignUserId() {
		return assignUserId;
	}

	public void setAssignUserId(String assignUserId) {
		this.assignUserId = assignUserId;
	}

	public Date getInitiateTime() {
		return initiateTime;
	}

	public void setInitiateTime(Date initiateTime) {
		this.initiateTime = initiateTime;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getAssignUserName() {
		return assignUserName;
	}

	public void setAssignUserName(String assignUserName) {
		this.assignUserName = assignUserName;
	}

	public Date getTaskDuration() {
		return taskDuration;
	}

	public void setTaskDuration(Date taskDuration) {
		this.taskDuration = taskDuration;
	}

	public String getTaskLevel() {
		return taskLevel;
	}

	public void setTaskLevel(String taskLevel) {
		this.taskLevel = taskLevel;
	}

	public String getTaskState() {
		return taskState;
	}

	public void setTaskState(String taskState) {
		this.taskState = taskState;
	}

	public String getTaskDescribe() {
		return taskDescribe;
	}

	public void setTaskDescribe(String taskDescribe) {
		this.taskDescribe = taskDescribe;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getTaskType() {
		return taskType;
	}

	public void setTaskType(String taskType) {
		this.taskType = taskType;
	}

	public String getTaskPcUrl() {
		return taskPcUrl;
	}

	public void setTaskPcUrl(String taskPcUrl) {
		this.taskPcUrl = taskPcUrl;
	}

	public String getTaskMaUrl() {
		return taskMaUrl;
	}

	public void setTaskMaUrl(String taskMaUrl) {
		this.taskMaUrl = taskMaUrl;
	}

	public Long getPromoterId() {
		return promoterId;
	}

	public void setPromoterId(Long promoterId) {
		this.promoterId = promoterId;
	}

	public String getPromoterName() {
		return promoterName;
	}

	public void setPromoterName(String promoterName) {
		this.promoterName = promoterName;
	}

	public String getSolution() {
		return solution;
	}

	public void setSolution(String solution) {
		this.solution = solution;
	}

	public List<TaskHistoryVO> getHistoryList() {
		return historyList;
	}

	public void setHistoryList(List<TaskHistoryVO> historyList) {
		this.historyList = historyList;
	}

	public List<TaskReceiverVO> getReceiverList() {
		return receiverList;
	}

	public void setReceiverList(List<TaskReceiverVO> receiverList) {
		this.receiverList = receiverList;
	}
	
}
