package com.ejianc.business.taxnew.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 收票登记-物资发票明细
 * 
 * @author generator
 * 
 */
public class InvoiceReceiveRegistDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long receiveBillId; // 收票登记单id
    private Long materialContractId; // 所属物资合同Id
    private Long materialContractDetailId; // 所属物资合同明细Id
    private Long materialTypeId; // 物资分类Id
    private String materialTypeName; // 物资分类名称
    private Long materialId; // 物资Id
    private String materialCode; // 物资名称
    private String materialName; // 物资名称
    private String spec; // 规则型号
    private String measureUnit; // 计量单位
    private Long brandId; // 品牌
    private String brandName; // 品牌
    private BigDecimal count; // 数量
    private BigDecimal unitPrice; // 单价
    private BigDecimal totalAmount; // 金额
    private String materialRemark; // 备注
    

    public Long getReceiveBillId() {
        return receiveBillId;
    }

    public void setReceiveBillId(Long receiveBillId) {
        this.receiveBillId = receiveBillId;
    }
    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }
    public Long getMaterialContractDetailId() {
        return materialContractDetailId;
    }

    public void setMaterialContractDetailId(Long materialContractDetailId) {
        this.materialContractDetailId = materialContractDetailId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    @ReferSerialTransfer(referCode = "support-brand")
    public Long getBrandId() {
        return brandId;
    }

    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }
    
}
