package com.ejianc.business.tax.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 合同收票
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_tax_invoice_receive")
public class InvoiceReceiveVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    @TableField("contract_type")
    private String contractType;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目主键
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 组织主键
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 购方主键
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 购方名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 纳税人识别号
     */
    @TableField("customer_credit_code")
    private String customerCreditCode;

    /**
     * 销方名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 销方主键
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 销方纳税人识别号
     */
    @TableField("supplier_credit_code")
    private String supplierCreditCode;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 开票类型:1,有合同,2,无合同
     */
    @TableField("type")
    private Integer type;

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    @TableField("invoice_type")
    private Long invoiceType;

    /**
     * 发票号码
     */
    @TableField("invoice_number")
    private String invoiceNumber;

    /**
     * 发票代码
     */
    @TableField("invoice_code")
    private String invoiceCode;

    /**
     * 开票日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date invoiceDate;

    /**
     * 发票金额（不含税）
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    @TableField("invoice_tax_mny")
    private BigDecimal invoiceTaxMny;
    /**
     * 编码
     */
    private String billCode;
    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 单据状态（审批必须字段）
     */
    private String billStateName;
    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    @TableField("invoice_type_name")
    private String invoiceTypeName;
    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;
    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;
    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;


    private List<InvoiceReceiveSettleVO> settleDetails = new ArrayList<>();

    @TableField(value="verify_mny")
    private java.math.BigDecimal verifyMny; // 核销金额合计
    @TableField(value="verify_tax_mny")
    private java.math.BigDecimal verifyTaxMny; // 核销金额合计(含税)
    @TableField(value="verify_tax")
    private java.math.BigDecimal verifyTax; // 核销金额税额

    /**
     * 部门主键
     */
    private Long deptId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 来源ID
     */
    private String sourceId;

    public BigDecimal getVerifyMny() {
        return verifyMny;
    }

    public void setVerifyMny(BigDecimal verifyMny) {
        this.verifyMny = verifyMny;
    }

    public BigDecimal getVerifyTaxMny() {
        return verifyTaxMny;
    }

    public void setVerifyTaxMny(BigDecimal verifyTaxMny) {
        this.verifyTaxMny = verifyTaxMny;
    }

    public BigDecimal getVerifyTax() {
        return verifyTax;
    }

    public void setVerifyTax(BigDecimal verifyTax) {
        this.verifyTax = verifyTax;
    }

    public List<InvoiceReceiveSettleVO> getSettleDetails() {
        return settleDetails;
    }

    public void setSettleDetails(List<InvoiceReceiveSettleVO> settleDetails) {
        this.settleDetails = settleDetails;
    }


    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {

        this.billStateName = billStateName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }


    public String getCustomerCreditCode() {
        return customerCreditCode;
    }

    public void setCustomerCreditCode(String customerCreditCode) {
        this.customerCreditCode = customerCreditCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    private Integer contractVersion;

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {

        this.contractVersion = contractVersion;
    }
    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
