package com.ejianc.business.taxnew.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 进项发票池
 * 
 * @author generator
 * 
 */
public interface IInvoiceReceivePoolService extends IBaseService<InvoiceReceivePoolEntity> {
    /** 更新指定发票状态 */
    void updateInvoiceReceivePoolEntityUseState(List<Long> ids, Integer state);
    /** 更新指定发票 抵扣申请单id */
    void updateInvoiceReceivePoolEntityDeducApplyIds(List<Long> ids, Long applyId);
    /** 批量认证 */
    void authBatch(List<Long> ids,String periodOfTax, String authDate, Integer authState, String authPerson);
    /** 批量取消认证 */
    void noAuthBatch(List<Long> ids);

    /**
     * 根据合同id查询发票含税不含税金额
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> querySumMnyTax(Long contractId);
}
