package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("invoiceReceive")
public class InvoiceReceiveBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交前回调--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = invoiceReceiveService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceReceiveEntity> list = invoiceReceiveService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核前回调--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = invoiceReceiveService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceReceiveEntity> list = invoiceReceiveService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入收票审批同意后回写--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = invoiceReceiveService.selectById(billId);
//        合同类型,1-分包,2-设备采购,3-设备租赁
        if (null != invoiceReceiveEntity.getContractId()){
        if (invoiceReceiveEntity.getContractType().equals("1")){
            CommonResponse<String> stringCommonResponse = subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        if (invoiceReceiveEntity.getContractType().equals("2")) {
            //设备合同数据回写
            CommonResponse<String> stringCommonResponse = equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        if (invoiceReceiveEntity.getContractType().equals("3")) {
            //设备合同数据回写
            CommonResponse<String> stringCommonResponse = equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        if (invoiceReceiveEntity.getContractType().equals("4")) {
            //设备合同数据回写
            logger.info("进入收票审批同意后回写-物资采购--- billId:" + billId + "  state:" + state);

            return CommonResponse.success();
        }
        if (invoiceReceiveEntity.getContractType().equals("5")) {
            //设备合同数据回写
            logger.info("进入收票审批同意后回写-物资租赁--- billId:" + billId + "  state:" + state);
            return CommonResponse.success();
        }
        }
        return  CommonResponse.success();
    }
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入收票撤回后回写--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = invoiceReceiveService.selectById(billId);
//        合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
        if (null != invoiceReceiveEntity.getContractId()) {
            if (invoiceReceiveEntity.getContractType().equals("1")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("2")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("3")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                //设备合同数据回写
                logger.info("进入收票撤回后回写-物资采购--- billId:" + billId + "  state:" + state);

                return CommonResponse.success();
            }
            if (invoiceReceiveEntity.getContractType().equals("5")) {
                //设备合同数据回写
                logger.info("进入收票撤回后回写-物资租赁--- billId:" + billId + "  state:" + state);
                return CommonResponse.success();
            }
        }
        return  CommonResponse.success();
    }

}
