/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.tax.utils.ConvertUpMoney;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistDetailVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl
extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity>
implements IInvoiceReceiveRegistService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "tax-receive-code-001";
    private static final String configCodeDm = "TAX_FPDM";
    private static final String configCodeHm = "TAX_FPHM";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        Long invoiceQuantity = 0L;
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            this.checkPool(entity.getInvoiceReceiveList());
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            invoiceQuantity = entity.getInvoiceReceiveList().stream().filter(e -> !"del".equals(e.getRowState())).count();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    poolEntity.setBillCode((String)billCode.getData());
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)poolEntity), (String[])new String[]{"invoiceType", "invoiceTypeName"});
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType() + ""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setContractId(entity.getContractId());
                poolEntity.setContractName(entity.getContractName());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
                if (entity.getPurchaseType() != null) {
                    poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
                }
                if (entity.getDependOnProject() != null) {
                    poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
                }
                if (entity.getReceiveType() != null) {
                    poolEntity.setContractType(String.valueOf(entity.getReceiveType()));
                }
                if (poolEntity.getContractId() != null) {
                    poolEntity.setType(1);
                } else {
                    poolEntity.setType(2);
                }
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                poolEntity.setContractCode(entity.getContractCode());
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            }
        }
        entity.setInvoiceQuantity(invoiceQuantity.intValue());
        return super.saveOrUpdateNoES((Object)entity);
    }

    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        ArrayList<String> invoiceNumberList = new ArrayList<String>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            String invoiceNumber;
            if ("del".equals(vo.getRowState()) || !StringUtils.isNotEmpty((String)(invoiceNumber = vo.getInvoiceNumber()))) continue;
            if (invoiceNumberList.contains(invoiceNumber)) {
                throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + invoiceNumber + "\u3011\u5f55\u5165\u91cd\u590d\uff01");
            }
            invoiceNumberList.add(invoiceNumber);
            LambdaQueryWrapper invoiceNumberQueryWrapper = new LambdaQueryWrapper();
            invoiceNumberQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, (Object)invoiceNumber);
            invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, (Object)vo.getReceiveBillId());
            int count = this.invoiceReceivePoolService.count((Wrapper)invoiceNumberQueryWrapper);
            if (count <= 0) continue;
            throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + vo.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @Override
    public List<InvoiceReceivePoolEntity> generateInvoiceReceivePool(InvoiceReceiveRegistEntity entity) {
        InvoiceReceivePoolEntity poolEntity = new InvoiceReceivePoolEntity();
        poolEntity.setOriginType(0);
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        poolEntity.setBillCode((String)billCode.getData());
        poolEntity.setId(null);
        poolEntity.setReceiveBillCode(entity.getCode());
        poolEntity.setReceiveBillId(entity.getId());
        poolEntity.setType(2);
        poolEntity.setBillState(0);
        CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = this.getDefMapName((List)defList.getData());
        String invoiceType = defMap.get("\u5176\u4ed6");
        if (!StringUtils.isNotEmpty((String)invoiceType)) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u53d1\u7968\u7c7b\u578b\u83b7\u53d6\u5931\u8d25");
        }
        poolEntity.setInvoiceType(Long.valueOf(invoiceType));
        poolEntity.setInvoiceTypeName("\u5176\u4ed6");
        poolEntity.setInvoiceCode(this.getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(this.getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(ComputeUtil.nullToZero((BigDecimal)entity.getCurrentReceiveMny()));
        poolEntity.setTaxMny(ComputeUtil.nullToZero((BigDecimal)entity.getTaxMny()));
        poolEntity.setInvoiceTaxMny(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)poolEntity.getInvoiceMny(), (BigDecimal)poolEntity.getTaxMny())));
        if (new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny()) == 0) {
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()) + "\u6574");
        } else {
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }
        poolEntity.setContractId(entity.getContractId());
        poolEntity.setContractCode(entity.getContractCode());
        poolEntity.setContractName(entity.getContractName());
        poolEntity.setSupplierId(entity.getSellerId());
        poolEntity.setSupplierName(entity.getSellerName());
        poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
        poolEntity.setCustomerId(entity.getBuyerId());
        poolEntity.setCustomerName(entity.getBuyerName());
        poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
        poolEntity.setEmployeeId(entity.getProcessPersonId());
        poolEntity.setEmployeeName(entity.getProcessPersonName());
        poolEntity.setRegist(false);
        poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
        poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
        poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
        poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
        poolEntity.setAuthState(0);
        poolEntity.setDeductionState(0);
        poolEntity.setFlag(0);
        if (entity.getPurchaseType() != null) {
            poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
        }
        if (entity.getDependOnProject() != null) {
            poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
        }
        if (entity.getReceiveType() != null) {
            poolEntity.setContractType(String.valueOf(entity.getReceiveType()));
        }
        if (poolEntity.getContractId() != null) {
            poolEntity.setType(1);
        } else {
            poolEntity.setType(2);
        }
        poolEntity.setOrgId(entity.getOrgId());
        poolEntity.setOrgName(entity.getOrgName());
        poolEntity.setProjectId(entity.getProjectId());
        poolEntity.setProjectName(entity.getProjectName());
        ArrayList<InvoiceReceivePoolEntity> list = new ArrayList<InvoiceReceivePoolEntity>();
        list.add(poolEntity);
        return list;
    }

    public String getBillCode(String code) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    public PSRMResponse saveOrUpdatePsrmObj(InvoiceReceiveRegistVO vo) {
        JSONObject json;
        JSONArray jArray;
        InvoiceReceivePoolVO invoiceReceivePoolVO = (InvoiceReceivePoolVO)vo.getInvoiceReceiveList().get(0);
        String signDate = DateUtil.format((Date)vo.getRegistDate(), (String)"yyyy-MM-dd");
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", (Object)vo.getCode());
        obj.put("f_status", (Object)"Y");
        obj.put("f_date", (Object)signDate);
        obj.put("f_billno", (Object)invoiceReceivePoolVO.getInvoiceNumber());
        Integer f_invoicetype = 1;
        Long invoiceType = invoiceReceivePoolVO.getInvoiceType();
        if (!invoiceType.equals(1277537516768632833L)) {
            f_invoicetype = invoiceType.equals(1277537563879055362L) ? Integer.valueOf(2) : Integer.valueOf(3);
        }
        obj.put("f_invoicetype", (Object)f_invoicetype);
        try {
            if (vo.getSellerId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getSellerId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                json = (JSONObject)jArray.get(0);
                obj.put("f_supplycode", (Object)json.getString("code"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getProjectId() != null) {
            jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getProjectId()), (String)"market-project");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                json = (JSONObject)jArray.get(0);
                obj.put("f_engineeringcode", (Object)json.getString("code"));
            }
        }
        obj.put("f_empname", (Object)vo.getProcessPersonName());
        obj.put("f_contractcode", (Object)vo.getContractCode());
        obj.put("f_synccreator", (Object)vo.getCreateUserName());
        UserContext userContext = this.sessionManager.getUserContext();
        obj.put("f_syncauditor", (Object)userContext.getUserName());
        ArrayList<JSONObject> detail = new ArrayList<JSONObject>();
        Integer receiveType = vo.getReceiveType();
        if (4 == receiveType) {
            List invoiceReceiveRegistDetailList = vo.getInvoiceReceiveRegistDetailList();
            for (InvoiceReceiveRegistDetailVO sub : invoiceReceiveRegistDetailList) {
                JSONObject subObj = new JSONObject();
                subObj.put("f_synentryid", (Object)sub.getId());
                subObj.put("f_materialcode", (Object)sub.getMaterialCode());
                subObj.put("f_spec", (Object)sub.getSpec());
                subObj.put("f_unit", (Object)sub.getMeasureUnit());
                subObj.put("f_qty", (Object)sub.getCount());
                subObj.put("f_auxtaxprice", (Object)sub.getUnitPrice());
                subObj.put("f_amount", (Object)sub.getTotalAmount());
                subObj.put("f_allamount", (Object)sub.getTotalAmount());
                subObj.put("f_note", (Object)sub.getMaterialRemark());
                subObj.put("f_sourcebillno", (Object)vo.getContractCode());
                subObj.put("f_contractsynId", (Object)sub.getMaterialContractDetailId());
                subObj.put("f_contractbillno", (Object)vo.getContractCode());
                subObj.put("f_cess", (Object)vo.getTaxRate());
                detail.add(subObj);
            }
        } else if (1 == receiveType) {
            JSONObject subObj = new JSONObject();
            subObj.put("f_synentryid", (Object)vo.getId());
            subObj.put("f_materialcode", (Object)"99999995");
            subObj.put("f_qty", (Object)1);
            subObj.put("f_auxtaxprice", (Object)vo.getCurrentReceiveMnyTax());
            subObj.put("f_allamount", (Object)vo.getCurrentReceiveMnyTax());
            subObj.put("f_amount", (Object)vo.getCurrentReceiveMnyTax());
            subObj.put("f_note", (Object)vo.getMemo());
            subObj.put("f_sourcebillno", (Object)vo.getContractCode());
            subObj.put("f_contractsynId", (Object)vo.getContractId());
            subObj.put("f_contractbillno", (Object)vo.getContractCode());
            subObj.put("f_cess", (Object)vo.getTaxRate());
            detail.add(subObj);
        }
        obj.put("detail", detail);
        return this.psrmRestUtil.postReq((Object)obj, this.getSaveMethodName());
    }

    public String getSaveMethodName() {
        return "dmp.purchaseinvoice.add";
    }

    public String getUpdateMethodName() {
        return null;
    }
}

