/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.resource.api.IResourceApi;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"invoiceReceiveRegist"})
public class InvoiceReceiveRegistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IResourceApi resourceApi;
    @Autowired
    private IFaceAndIdCardService faceAndIdCardService;
    @Autowired
    private ICommonBusinessService invoiceReceiveRegist;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @GetMapping(value={"/pushPsrm"})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> pushPsrm(@RequestParam(value="id") Long id) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(id));
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        if (this.psrmRestUtil.isRunMode().booleanValue()) {
            PSRMResponse resp = this.service.saveOrUpdatePsrmObj(vo);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(InvoiceReceiveRegistEntity::getPsrmReturncode, (Object)resp.getReturncode());
            updateWrapper.set(resp.isSuccess(), InvoiceReceiveRegistEntity::getPsrmCode, (Object)resp.getPsrmCode());
            updateWrapper.set(InvoiceReceiveRegistEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
            this.service.update((Wrapper)updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25" + JSONObject.toJSONString((Object)resp)));
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6570\u636e\u4e2d\u53f0\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/testBpm"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> testBpm(Long id) {
        this.invoiceReceiveRegist.afterApprovalProcessor(id, Integer.valueOf(1), null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceReceiveRegistEntity.class));
        this.service.insertOrUpdate(entity);
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(id));
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        param.getFuzzyFields().add("contractCode");
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("processPersonId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("processPersonId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceiveRegistVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List ids = pageData.getRecords().stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(InvoiceReceivePoolEntity::getReceiveBillId, ids);
            List invoiceReceiveList = this.invoiceReceivePoolService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)invoiceReceiveList)) {
                Map<Long, List<InvoiceReceivePoolEntity>> map = invoiceReceiveList.stream().collect(Collectors.groupingBy(InvoiceReceivePoolEntity::getReceiveBillId));
                pageData.getRecords().forEach(item -> {
                    List poolList = (List)map.get(item.getId());
                    if (poolList != null) {
                        String concatenatedInvoiceNumbers = poolList.stream().map(InvoiceReceivePoolEntity::getInvoiceNumber).filter(StringUtils::isNotEmpty).collect(Collectors.joining(", "));
                        String concatenatedInvoiceDates = poolList.stream().map(entity -> {
                            if (entity.getInvoiceDate() != null) {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                return sdf.format(entity.getInvoiceDate());
                            }
                            return "";
                        }).filter(ObjectUtil::isNotEmpty).collect(Collectors.joining(", "));
                        item.setInvoiceNumber(concatenatedInvoiceNumbers);
                        item.setInvoiceDate(concatenatedInvoiceDates);
                    }
                });
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"receivePool-import.xlsx", (String)"\u6536\u7968\u767b\u8bb0\u53d1\u7968\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<InvoiceReceivePoolVO> errorList = new ArrayList<InvoiceReceivePoolVO>();
        ArrayList<InvoiceReceivePoolVO> successList = new ArrayList<InvoiceReceivePoolVO>();
        CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = this.getDefMap((List)defList.getData());
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                InvoiceReceivePoolVO s = new InvoiceReceivePoolVO();
                List row = (List)result.get(i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(0))) || !"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(row.get(0)) && !"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968".equals(row.get(0)) && !"\u5176\u5b83".equals(row.get(0))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u7c7b\u578b\u9009\u62e9\u4e0d\u6b63\u786e\uff01");
                } else {
                    String invoiceType = defMap.get(row.get(0));
                    s.setInvoiceType(Long.valueOf(invoiceType));
                }
                s.setInvoiceTypeName((String)row.get(0));
                s.setInvoiceCode((String)row.get(1));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(2)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    s.setInvoiceNumber((String)row.get(2));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(3)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        s.setInvoiceDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)((String)row.get(3))));
                    }
                    catch (ParseException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        s.setInvoiceDate(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(4)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        s.setInvoiceMny(new BigDecimal((String)row.get(4)));
                    }
                    catch (NumberFormatException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u662f\u6b63\u786e\u7684\u6570\u5b57\u683c\u5f0f\uff01");
                        s.setInvoiceMny(null);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get(5)))) {
                    try {
                        s.setTaxMny(new BigDecimal((String)row.get(5)));
                    }
                    catch (NumberFormatException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7a0e\u989d\u4e0d\u662f\u6b63\u786e\u7684\u6570\u5b57\u683c\u5f0f\uff01");
                        s.setTaxMny(null);
                    }
                } else {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get(6)))) {
                    s.setContent((String)row.get(6));
                }
                if (s.getInvoiceMny() != null && s.getTaxMny() != null) {
                    s.setInvoiceTaxMny(s.getTaxMny().add(s.getInvoiceMny()));
                }
                if (StringUtils.isEmpty((CharSequence)s.getErrorMessage())) {
                    successList.add(s);
                    continue;
                }
                errorList.add(s);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("sellerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceiveRegistVO r = (InvoiceReceiveRegistVO)BeanMapper.map((Object)pool, InvoiceReceiveRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        if (CollectionUtils.isNotEmpty(voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(InvoiceReceivePoolEntity::getReceiveBillId, ids);
            List invoiceReceiveList = this.invoiceReceivePoolService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)invoiceReceiveList)) {
                Map<Long, List<InvoiceReceivePoolEntity>> map = invoiceReceiveList.stream().collect(Collectors.groupingBy(InvoiceReceivePoolEntity::getReceiveBillId));
                voList.forEach(item -> {
                    List poolList = (List)map.get(item.getId());
                    if (poolList != null) {
                        String concatenatedInvoiceNumbers = poolList.stream().map(InvoiceReceivePoolEntity::getInvoiceNumber).filter(StringUtils::isNotEmpty).collect(Collectors.joining(", "));
                        String concatenatedInvoiceDates = poolList.stream().map(entity -> {
                            if (entity.getInvoiceDate() != null) {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                return sdf.format(entity.getInvoiceDate());
                            }
                            return "";
                        }).filter(ObjectUtil::isNotEmpty).collect(Collectors.joining(", "));
                        item.setInvoiceNumber(concatenatedInvoiceNumbers);
                        item.setInvoiceDate(concatenatedInvoiceDates);
                    }
                    if (ObjectUtil.isNotEmpty((Object)item.getContractId())) {
                        String[] referCodeArr;
                        JSONArray jsonArray = null;
                        String referCode = "materialContract,sub-contract-register,equipment-purchase-contract,equipment-rent-contract,rmat-contract,other-contract";
                        for (String rc : referCodeArr = referCode.split(",")) {
                            try {
                                jsonArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(item.getContractId()), (String)rc);
                                if (jsonArray == null || jsonArray.size() <= 0) continue;
                                JSONObject json = (JSONObject)jsonArray.get(0);
                                item.setContractCode(json.getString("code"));
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceive-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryBuyerName"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryBuyerName(@RequestBody InvoiceReceiveRegistVO vo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)(vo.getDependOnProject().equals(1) ? "project_id" : "org_id"), (Object)vo.getBuyerHisQueryId());
        queryWrapper.isNull((Object)"contract_id");
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        ((QueryWrapper)queryWrapper.orderByDesc((Object)"regist_date")).last("limit 1");
        InvoiceReceiveRegistEntity one = (InvoiceReceiveRegistEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        InvoiceReceiveRegistVO ivo = null;
        if (one != null) {
            ivo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)one), InvoiceReceiveRegistVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", ivo);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @PostMapping(value={"/uploadFilesAndCheck"})
    @ResponseBody
    public CommonResponse<List<InvoiceReceivePoolVO>> uploadFilesAndCheck(@RequestBody List<AttachmentVO> files) {
        CommonResponse invoiceIdentification = this.resourceApi.checkResource("invoiceIdentificationNum", InvocationInfoProxy.getTenantid());
        if (!invoiceIdentification.isSuccess() || !((Boolean)invoiceIdentification.getData()).booleanValue()) {
            return CommonResponse.error((String)"\u8d35\u516c\u53f8\u5c1a\u672a\u8d2d\u4e70\u53d1\u7968\u8bc6\u522b\u670d\u52a1\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01");
        }
        if (ListUtil.isEmpty(files)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u8bc6\u522b\u7684\u6587\u4ef6\uff01");
        }
        ArrayList<InvoiceReceivePoolVO> resList = new ArrayList<InvoiceReceivePoolVO>();
        String msg = null;
        for (AttachmentVO file : files) {
            InvoiceReceivePoolVO poolVO = new InvoiceReceivePoolVO();
            poolVO.setRowState("add");
            poolVO.setId(Long.valueOf(IdWorker.getId()));
            poolVO.setFileId(file.getId().toString());
            poolVO.setFileName(file.getFileName());
            poolVO.getAttachIds().add(file.getId());
            String fileUrl = file.getImgServerPath() + file.getFilePath();
            String[] names = file.getFileName().split("\\.");
            String fileType = names[names.length - 1].toLowerCase();
            CommonResponse recognizeRes = this.faceAndIdCardService.recognizeInvoiceInfo(fileUrl, fileType);
            if (recognizeRes.isSuccess()) {
                JSONObject result = (JSONObject)recognizeRes.getData();
                poolVO.setIdentifyResult(result.toJSONString());
                poolVO.setInvoiceDate(result.getDate("InvoiceDate"));
                poolVO.setInvoiceCode(result.getString("InvoiceCode"));
                poolVO.setInvoiceNumber(result.getString("InvoiceNo"));
                poolVO.setInvoiceMny(result.getBigDecimal("WithoutTaxAmount"));
                poolVO.setTaxMny(result.getBigDecimal("TaxAmount"));
                poolVO.setInvoiceTaxMny(result.getBigDecimal("InvoiceAmount"));
                poolVO.setInvoiceTaxMnys(result.getString("SumAmount"));
                poolVO.setCheckCode(result.getString("AntiFakeCode"));
                poolVO.setCustomerName(result.getString("PayerName"));
                poolVO.setCustomerCreditCode(result.getString("PayerRegisterNo"));
                poolVO.setBuyerAddrPhone(result.getString("PayerAddress"));
                poolVO.setBuyerBankAccount(result.getString("PayerBankName"));
                poolVO.setSupplierName(result.getString("PayeeName"));
                poolVO.setSupplierCreditCode(result.getString("PayeeRegisterNo"));
                poolVO.setSellerAddrPhone(result.getString("PayeeBankName"));
                poolVO.setSellerBankAccount(result.getString("PayeeAddress"));
                poolVO.setOriginType(Integer.valueOf(3));
            } else {
                String resMsg = recognizeRes.getMsg();
                if (resMsg != null && resMsg.contains("\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6b64\u6b21\u6263\u51cf\u64cd\u4f5c")) {
                    msg = "\u53d1\u7968\u8bc6\u522b\u670d\u52a1\u6570\u91cf\u5df2\u7528\u5c3d\uff0c\u7eed\u8d39\u540e\u7ee7\u7eed\u4f7f\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01";
                    break;
                }
                poolVO.setIdentifyResult("\u8bc6\u522b\u5f02\u5e38:" + resMsg);
            }
            resList.add(poolVO);
        }
        return CommonResponse.success(msg, resList);
    }

    @PostMapping(value={"/checkByHands"})
    @ResponseBody
    public CommonResponse<List<InvoiceReceivePoolVO>> checkByHands(@RequestBody List<InvoiceReceivePoolVO> sourceList) {
        CommonResponse invoiceVerification = this.resourceApi.checkResource("invoiceVerificationNum", InvocationInfoProxy.getTenantid());
        if (!invoiceVerification.isSuccess() || !((Boolean)invoiceVerification.getData()).booleanValue()) {
            return CommonResponse.error((String)"\u8d35\u516c\u53f8\u5c1a\u672a\u8d2d\u4e70\u53d1\u7968\u9a8c\u771f\u670d\u52a1\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01");
        }
        String msg = null;
        ArrayList<InvoiceReceivePoolVO> resList = new ArrayList<InvoiceReceivePoolVO>();
        for (InvoiceReceivePoolVO poolVO : sourceList) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (poolVO.getIdentifyResult().contains("\u8bc6\u522b\u5f02\u5e38")) continue;
            map.put("fpdm", poolVO.getInvoiceCode());
            map.put("fphm", poolVO.getInvoiceNumber());
            map.put("kprq", DateFormatUtil.formatDate((String)"yyyyMMdd", (Date)poolVO.getInvoiceDate()));
            map.put("xym", poolVO.getCheckCode());
            JSONObject identifyResult = JSONObject.parseObject((String)poolVO.getIdentifyResult());
            if (StringUtils.isNotEmpty((CharSequence)poolVO.getInvoiceNumber()) && poolVO.getInvoiceNumber().length() == 20) {
                map.put("bhsje", identifyResult.getString("InvoiceAmount"));
            } else {
                map.put("bhsje", identifyResult.getString("WithoutTaxAmount"));
            }
            CommonResponse authRes = this.faceAndIdCardService.authInvoiceInfo(map);
            if (authRes.isSuccess()) {
                JSONObject result = (JSONObject)authRes.getData();
                poolVO.setCheckResult(result.getString("result"));
            } else {
                String resMsg = authRes.getMsg();
                if (resMsg != null && resMsg.contains("\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6b64\u6b21\u6263\u51cf\u64cd\u4f5c")) {
                    msg = "\u53d1\u7968\u9a8c\u771f\u670d\u52a1\u6570\u91cf\u5df2\u7528\u5c3d\uff0c\u7eed\u8d39\u540e\u7ee7\u7eed\u4f7f\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01";
                    break;
                }
                poolVO.setCheckResult("\u9a8c\u771f\u5f02\u5e38\uff1a" + authRes.getMsg());
            }
            resList.add(poolVO);
        }
        return CommonResponse.success(msg, resList);
    }

    @PostMapping(value={"/queryAllPrintFile"})
    @ResponseBody
    public CommonResponse<Map<String, List<String>>> queryAllPrintFile(@RequestBody List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(InvoiceReceivePoolEntity::getReceiveBillId, ids);
        List detailFileList = this.invoiceReceivePoolService.list((Wrapper)queryWrapper);
        ArrayList subIds = new ArrayList();
        Map<Long, Long> pidIdMap = detailFileList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getReceiveBillId()));
        List detailIds = detailFileList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        subIds.addAll(detailIds);
        JSONObject params = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("sourceIds", (Object)subIds.stream().map(item -> item.toString()).collect(Collectors.joining(",")));
        this.attachmentApi.pdfFileToImg(param);
        params.put("sourceIds", (Object)JSONObject.toJSONString(detailIds));
        CommonResponse attachResp = this.attachmentApi.queryAllBySourceIdList(params);
        if (!attachResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u6253\u5370\u9644\u4ef6\u4fe1\u606f\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)attachResp));
            return CommonResponse.error((String)"\u83b7\u53d6\u6253\u5370\u9644\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        HashMap ocrFileIdMap = new HashMap();
        List<String> fileType = Arrays.asList("jpg", "bmp", "png", "jpeg");
        Map resp = ((List)attachResp.getData()).stream().filter(item -> !"printTemplate".equals(item.getSourceType()) && fileType.contains(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).map(item -> {
            if (pidIdMap.containsKey(item.getSourceId())) {
                item.setSourceId((Long)pidIdMap.get(item.getSourceId()));
            }
            return item;
        }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getOnlinePath())) {
                return item.getOnlinePath();
            }
            return this.baseHost + "filepreview/" + item.getFilePath();
        }, Collectors.toList())));
        HashMap subIdMap = new HashMap();
        ((List)attachResp.getData()).stream().filter(item -> (ocrFileIdMap.containsKey(item.getSourceId()) || pidIdMap.containsKey(item.getSourceId())) && "pdf".equalsIgnoreCase(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).forEach(item -> subIdMap.put(item.getId(), item.getSourceId()));
        if (!subIdMap.isEmpty()) {
            params.put("sourceIds", (Object)JSONObject.toJSONString(new ArrayList(subIdMap.keySet())));
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)attachResp));
                return CommonResponse.error((String)"\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25!");
            }
            List attfileList = (List)attachResp.getData();
            ArrayList<AttachmentVO> fileList = new ArrayList<AttachmentVO>();
            HashSet sourceIds = new HashSet();
            for (AttachmentVO attachmentVO : attfileList) {
                if (sourceIds.contains(attachmentVO.getSourceId())) continue;
                fileList.add(attachmentVO);
            }
            Map subFileMap = fileList.stream().filter(item -> fileType.contains(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).map(item -> {
                if (subIdMap.containsKey(item.getSourceId()) && pidIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                    item.setSourceId((Long)pidIdMap.get(subIdMap.get(item.getSourceId())));
                }
                if (subIdMap.containsKey(item.getSourceId()) && ocrFileIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                    item.setSourceId((Long)ocrFileIdMap.get(subIdMap.get(item.getSourceId())));
                }
                return item;
            }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getOnlinePath())) {
                    return item.getOnlinePath();
                }
                return this.baseHost + "filepreview/" + item.getFilePath();
            }, Collectors.toList())));
            for (String key : subFileMap.keySet()) {
                if (resp.containsKey(key)) {
                    resp.get(key).addAll(subFileMap.get(key));
                    continue;
                }
                resp.put(key, subFileMap.get(key));
            }
        }
        return CommonResponse.success(resp);
    }
}

