package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveSettleEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.util.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("invoiceReceive")
public class InvoiceReceiveBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IRmatContractApi rmatContractApi;

    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;

    @Autowired
    private NCUtil ncUtil;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交前回调--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = invoiceReceiveService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceReceiveEntity> list = invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核前回调--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = invoiceReceiveService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceReceiveEntity> list = invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        } else {
            return CommonResponse.error(res.getMsg());
        }
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票审批同意后回写--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = invoiceReceiveService.selectById(billId);
//        合同类型,1-分包,2-设备采购,3-设备租赁
        if (null != invoiceReceiveEntity.getContractId()) {
            if (invoiceReceiveEntity.getContractType().equals("1")) {
                CommonResponse<String> stringCommonResponse = subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("2")) {
                //设备合同数据回写
                CommonResponse<String> stringCommonResponse = equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("3")) {
                //设备合同数据回写
                CommonResponse<String> stringCommonResponse = equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                //物资采购合同数据回写
                logger.info("进入收票审批同意后回写-物资采购--- billId:" + billId + "  state:" + state);
                List<InvoiceReceiveSettleEntity> settleDetails = invoiceReceiveEntity.getSettleDetails();
                List<Map<String,String>> settleList = new ArrayList<>();
                for (InvoiceReceiveSettleEntity settleEntity:settleDetails){
                    Map<String,String> settle = new TreeMap<>();
                    settle.put("settleId",String.valueOf(settleEntity.getSettleId()));
                    settle.put("settleCode",settleEntity.getSettleCode());
                    settle.put("sumVerifyMny",String.valueOf(settleEntity.getSumVerifyMny()) );
                    settle.put("sumVerifyTaxMny",String.valueOf(settleEntity.getSumVerifyTaxMny()));
                    settleList.add(settle);
                }
                CommonResponse<String> stringCommonResponse = materialSettlementApi.updateSettlementtotalInvoiceVerifyMny(settleList);
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!"+stringCommonResponse.getMsg());
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("5")) {
                //周转材租赁合同数据回写
                CommonResponse<String> stringCommonResponse = rmatContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("6")) {
                //其它支出合同数据回写
                CommonResponse<String> stringCommonResponse = otherContractApi.otherAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("审批回写异常!");
                }
            }
        }

        //审批通过后回写NC
        pushToNcAr(invoiceReceiveEntity);

        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票撤回后回写--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = invoiceReceiveService.selectById(billId);
//        合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
        if (null != invoiceReceiveEntity.getContractId()) {
            if (invoiceReceiveEntity.getContractType().equals("1")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                   // return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("2")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("3")) {
                //设备合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                //物资采购合同数据回写
                logger.info("进入收票撤回后回写-物资采购--- billId:" + billId + "  state:" + state);
                List<InvoiceReceiveSettleEntity> settleDetails = invoiceReceiveEntity.getSettleDetails();
                List<Map<String,String>> settleList = new ArrayList<>();
                for (InvoiceReceiveSettleEntity settleEntity:settleDetails){
                    Map<String,String> settle = new TreeMap<>();
                    settle.put("settleId",String.valueOf(settleEntity.getSettleId()));
                    settle.put("settleCode",settleEntity.getSettleCode());
                    settle.put("alreadyVerifyMny",String.valueOf(settleEntity.getAlreadyVerifyMny()) );
                    settle.put("alreadyVerifyTaxMny",String.valueOf(settleEntity.getAlreadyVerifyTaxMny()));
                    settleList.add(settle);
                }
                CommonResponse<String> stringCommonResponse = materialSettlementApi.callBackSettlementtotalInvoiceVerify(settleList);
                if (stringCommonResponse.isSuccess()) {
                   // return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!"+stringCommonResponse.getMsg());
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("5")) {
                //周转材租赁合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = rmatContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("6")) {
                //其它支出合同数据回写
                CommonResponse<JSONObject> jsonObjectCommonResponse = otherContractApi.otherAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    //return CommonResponse.success();
                } else {
                    return CommonResponse.error("撤回回写异常!");
                }
            }

        }

        // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(invoiceReceiveEntity.getSourceId())){
            String[] split = invoiceReceiveEntity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deleteapbill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<InvoiceReceiveEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(InvoiceReceiveEntity::getSourceId,null);
            wrapper.eq(InvoiceReceiveEntity::getId,billId);
            invoiceReceiveService.update(wrapper);
        }

        return CommonResponse.success();
    }

    private void pushToNcAr(InvoiceReceiveEntity invoiceReceiveEntity){
        ApBillVO apNcVo = transferToNCVO(invoiceReceiveEntity);

        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(invoiceReceiveEntity.getProjectId())).get(0);
        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for(Long orgId:orgIds){
            apNcVo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(apNcVo).toString());// 调用NC传凭证接口
            sourceIds += sourceId+",";
        }
        sourceIds = sourceIds.substring(0,sourceIds.length()-1);

        LambdaUpdateWrapper<InvoiceReceiveEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(InvoiceReceiveEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(InvoiceReceiveEntity::getId, invoiceReceiveEntity.getId());
        invoiceReceiveService.update(wrapper);
    }

    private ApBillVO transferToNCVO(InvoiceReceiveEntity entity){

        logger.info("----收票登记应付单传凭证开始:");

        ApBillVO ncVo = new ApBillVO();
        ncVo.setBusitype("apbill"); // 业务标识(默认apbill)
        ncVo.setTradetype("F1-Cxx-004"); // 交易类型

        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ncVo.setPk_project(String.valueOf(entity.getProjectId())); // 项目主键
        ncVo.setDef1(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
        ncVo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
        ncVo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(project.getAreaCode())){
            throw new BusinessException("项目-区域不能为空！");
        }
        ncVo.setDef5(project.getAreaCode());// 区域编码

        ncVo.setPk_supplier(String.valueOf(entity.getSupplierId()));  //供应商id
        SupplierVO supplierVO = ncUtil.querySupplierById(entity.getSupplierId());
        ncVo.setDef6(supplierVO.getInsideOrgId()!=null); //是否内部客商

        ncVo.setPk_dept(String.valueOf(entity.getDeptId())); //部门
        ncVo.setDef12(String.valueOf(entity.getId())); // PM主键id
        ncVo.setDef19(entity.getBillCode()); //单据编号

        if (entity.getType()==1){//有合同收票
            if ("1".equals(entity.getContractType())) {//分包
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200529000000001");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("2".equals(entity.getContractType())) {//设备采购
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200528000000001");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("3".equals(entity.getContractType())) {//设备租赁
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200528000000003");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("4".equals(entity.getContractType())) {//物资
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200608000000001");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("5".equals(entity.getContractType())) {//周转材租赁
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT210615000000001");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("6".equals(entity.getContractType())) {//其它支出
                JSONObject object = ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT210916000000001");
                ncVo.setDef7(ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
        }
        if (entity.getType()==2){//无合同收票
            ncVo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        }

        List<ApBillDetailVO> detailVOS = new ArrayList<>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getInvoiceMny()); //发票金额无税
        detailVO.setLocal_mny(entity.getInvoiceTaxMny()); //发票金额含税
        detailVO.setTaxmny(entity.getTaxMny());//发票金额税额
        detailVOS.add(detailVO);

        ncVo.setDetail(detailVOS);
        return ncVo;

    }


}
