package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.util.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("invoiceOpen")
public class InvoiceOpenBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private NCUtil ncUtil;

    @Autowired
    private IIncomeContractApi incomeContractApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交前回调--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = invoiceOpenService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceOpenEntity> list = invoiceOpenService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核前回调--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = invoiceOpenService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceOpenEntity> list = invoiceOpenService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票审批同意后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);

        //审批通过后回写NC
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(invoiceOpenEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            pushToNcAr(invoiceOpenEntity);
        }

        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()) {
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), true);
            if (stringCommonResponse.isSuccess()) {
                //return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }

        return CommonResponse.success();

    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票撤回后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);

        // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(invoiceOpenEntity.getSourceId())){
            String[] split = invoiceOpenEntity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletearbill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<InvoiceOpenEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(InvoiceOpenEntity::getSourceId,null);
            wrapper.eq(InvoiceOpenEntity::getId,billId);
            invoiceOpenService.update(wrapper);
        }

        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()){
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), false);
            if (stringCommonResponse.isSuccess()) {
                //return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }

        return CommonResponse.success();
    }

    /**
     * 推送NC传应付单凭证
     * @param invoiceOpenEntity
     */
    private void pushToNcAr(InvoiceOpenEntity invoiceOpenEntity){
        ArBillVO arNcVo = transferToNCVO(invoiceOpenEntity);

        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(invoiceOpenEntity.getProjectId())).get(0);
//        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        List<Long> orgIds = ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
        String sourceIds = "";
        for(Long orgId:orgIds){
            arNcVo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(arNcVo).toString());// 调用NC传凭证接口
            sourceIds += sourceId+",";
        }
        sourceIds = sourceIds.substring(0,sourceIds.length()-1);

        LambdaUpdateWrapper<InvoiceOpenEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(InvoiceOpenEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(InvoiceOpenEntity::getId, invoiceOpenEntity.getId());
        invoiceOpenService.update(wrapper);
    }

    private ArBillVO transferToNCVO(InvoiceOpenEntity entity){

        logger.info("----开票登记应收单传凭证开始:");
        ArBillVO ncVo = new ArBillVO();
        ncVo.setBusitype("arbill");
        ncVo.setTradetype("F0-Cxx-004");

        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);

        ncVo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        ncVo.setDef1(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
        ncVo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
        ncVo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
        ncVo.setDef4(ncUtil.getDefDocById(project.getEngineeringType()).getCode());// 工程类型
        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(project.getAreaCode())){
            throw new BusinessException("项目-区域不能为空！");
        }
        ncVo.setDef5(project.getAreaCode());// 区域编码

        if (entity.getType()==1){//有合同开票
            CommonResponse<ContractVo> contractVoCommonResponse = incomeContractApi.queryDetail(entity.getContractId());
            if (contractVoCommonResponse.isSuccess()){
                ContractVo data = contractVoCommonResponse.getData();
                ncVo.setDef8(data.getBillCode()); //合同编码
                ncVo.setDef9(data.getContractName()); //合同名称
                ncVo.setDef7(ncUtil.getTaxRateDefCode(data.getTaxRate()));// 税率
            }
        }
        if (entity.getType()==2){//无合同开票
            ncVo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        }

        ncVo.setPk_customer(String.valueOf(entity.getCustomerId())); //客户
        CustomerVO customerVO = ncUtil.queryCustomerById(entity.getCustomerId());
        ncVo.setDef6(customerVO.getInsideOrgId()!=null); //是否内部客商
        ncVo.setPk_dept(String.valueOf(project.getDeptId())); //部门
        ncVo.setDef12(String.valueOf(entity.getId())); //PM单据主键
        ncVo.setDef19(entity.getBillCode()); //单据编号
        ncVo.setDef20(ncUtil.getWebSite("ejc-tax-frontend/#/invoiceReceive/card?id=" + entity.getId()));// 外部访问url
        ncVo.setDef21("BT200605000000001");// 单据类型

        List<ArBillDetailVO> detailVOS = new ArrayList<>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getInvoiceMny()); //发票金额不含税
        detailVO.setTotalmny(entity.getInvoiceTaxMny()); //发票金额含税
        detailVO.setTaxmny(entity.getTaxMny()); //发票金额税额
        detailVOS.add(detailVO);

        ncVo.setDetail(detailVOS);
        return ncVo;


    }

}
