/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.util.NCUtil;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpen")
public class InvoiceOpenBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private IIncomeContractApi incomeContractApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceOpenService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceOpenService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse;
        this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(invoiceOpenEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNcAr(invoiceOpenEntity);
        }
        if (null != invoiceOpenEntity.getContractId() && !(stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(true))).isSuccess()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse;
        this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        if (StringUtils.isNotEmpty((CharSequence)invoiceOpenEntity.getSourceId())) {
            String[] split;
            for (String sourceId : split = invoiceOpenEntity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deletearbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(InvoiceOpenEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.invoiceOpenService.update((Wrapper)wrapper);
        }
        if (null != invoiceOpenEntity.getContractId() && !(stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(false))).isSuccess()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
        }
        return CommonResponse.success();
    }

    private void pushToNcAr(InvoiceOpenEntity invoiceOpenEntity) {
        ArBillVO arNcVo = this.transferToNCVO(invoiceOpenEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(invoiceOpenEntity.getProjectId())).get(0);
        List<Long> orgIds = this.ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            arNcVo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)arNcVo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(InvoiceOpenEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)invoiceOpenEntity.getId());
        this.invoiceOpenService.update((Wrapper)wrapper);
    }

    private ArBillVO transferToNCVO(InvoiceOpenEntity entity) {
        CommonResponse contractVoCommonResponse;
        this.logger.info("----\u5f00\u7968\u767b\u8bb0\u5e94\u6536\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ArBillVO ncVo = new ArBillVO();
        ncVo.setBusitype("arbill");
        ncVo.setTradetype("F0-Cxx-004");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ncVo.setPk_project(String.valueOf(entity.getProjectId()));
        ncVo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        ncVo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        ncVo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        ncVo.setDef4(this.ncUtil.getDefDocById(project.getEngineeringType()).getCode());
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ncVo.setDef5(project.getAreaCode());
        if (entity.getType() == 1 && (contractVoCommonResponse = this.incomeContractApi.queryDetail(entity.getContractId())).isSuccess()) {
            ContractVo data = (ContractVo)contractVoCommonResponse.getData();
            ncVo.setDef8(data.getBillCode());
            ncVo.setDef9(data.getContractName());
            ncVo.setDef7(this.ncUtil.getTaxRateDefCode(data.getTaxRate()));
        }
        if (entity.getType() == 2) {
            ncVo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        }
        ncVo.setPk_customer(String.valueOf(entity.getCustomerId()));
        CustomerVO customerVO = this.ncUtil.queryCustomerById(entity.getCustomerId());
        ncVo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        ncVo.setPk_dept(String.valueOf(project.getDeptId()));
        ncVo.setDef12(String.valueOf(entity.getId()));
        ncVo.setDef19(entity.getBillCode());
        ncVo.setDef20(this.ncUtil.getWebSite("ejc-tax-frontend/#/invoiceReceive/card?id=" + entity.getId()));
        ncVo.setDef21("BT200605000000001");
        ArrayList<ArBillDetailVO> detailVOS = new ArrayList<ArBillDetailVO>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getInvoiceMny());
        detailVO.setTotalmny(entity.getInvoiceTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        ncVo.setDetail(detailVOS);
        return ncVo;
    }
}

