package com.ejianc.business.tax.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.util.NCUtil;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 合同收票表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@RestController
@RequestMapping("invoiceOpen")
public class InvoiceOpenController {
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IOrgApi orgApi;
    /**
     * 新增或者修改
     *
     * @param invoiceOpenVO
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceOpenVO> saveOrUpdate(@RequestBody InvoiceOpenVO invoiceOpenVO) {
        CommonResponse<InvoiceOpenVO> response = invoiceOpenService.saveOrUpdate(invoiceOpenVO);
        return response;
    }
    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenVO> queryDetail(@RequestParam Long id) {
        InvoiceOpenVO invoiceOpenVo = invoiceOpenService.queryDetail(id);
        return CommonResponse.success(invoiceOpenVo);
    }
    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenVO> vos) {
        invoiceOpenService.deleteInvoiceOpen(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 列表查询
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject>  pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("invoiceCode");
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 是否生成凭证
        NCUtil.voucherParam(param);
        IPage<InvoiceOpenEntity> pageData= invoiceOpenService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * 查询指定组织本下的所有租赁合同信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/invoiceOpenRef")
    public CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                 @RequestParam(defaultValue = "10") Integer pageSize,
                                                                 @RequestParam(value = "condition", required = false) String condition,
                                                                 @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            //有合同
            if(null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
                queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 1));//有合同
                if(null != conditionMap.get("orgId")) {
                    Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
                }
            } else {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
                if(null != conditionMap.get("customerId")) {
                    Long customerId = Long.valueOf(conditionMap.get("customerId").toString());
                    queryParam.getParams().put("customer_id", new Parameter(QueryParam.EQ, customerId));
                }
                queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 2));//无合同
            }
        }
        IPage<InvoiceOpenEntity> pageData = invoiceOpenService.queryPage(queryParam,false);
        IPage<InvoiceOpenVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class));
        return CommonResponse.success("开票登记参照查询成功！", result);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("invoiceCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(10000);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("收票查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        // 是否生成凭证
        NCUtil.voucherParam(param);
        IPage<InvoiceOpenEntity> pageData= invoiceOpenService.queryPage(param,false);
        List<InvoiceOpenVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("open.xlsx", beans, response);
    }
}
