package com.ejianc.business.tax.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 有合同开票 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@RestController
@RequestMapping("invoiceReceive")
public class InvoiceReceiveController {
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IOrgApi orgApi;
    /**
     * 新增或者修改
     *
     * @param invoiceReceiveVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveVO> saveOrUpdate(@RequestBody InvoiceReceiveVO invoiceReceiveVO) {
        CommonResponse<InvoiceReceiveVO> response = invoiceReceiveService.saveOrUpdate(invoiceReceiveVO);
        return response;
    }
    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveVO> queryDetail(@RequestParam Long id) {
        InvoiceReceiveVO invoiceReceiveVo = invoiceReceiveService.queryDetail(id);
        return CommonResponse.success(invoiceReceiveVo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveVO> vos) {
        invoiceReceiveService.deleteInvoiceReceive(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 列表查询
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("invoiceCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("查询列表数据成功！",invoiceReceiveService.queryPage(param,false));
    }
    /**
     * 查询指定组织本下的所有租赁合同信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/invoiceReceiveRef")
    public CommonResponse<IPage<InvoiceReceiveVO>> projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                @RequestParam(defaultValue = "10") Integer pageSize,
                                                                @RequestParam(value = "condition", required = false) String condition,
                                                                @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orgId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, projectId));
            }
            if(null != conditionMap.get("contractId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceiveEntity> pageData = invoiceReceiveService.queryPage(queryParam,false);
        IPage<InvoiceReceiveVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceReceiveVO.class));
        return CommonResponse.success("开票登记参照查询成功！", result);
    }
}
