package com.ejianc.business.tax.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/tax/")
public class InvoiceApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IInvoiceOpenService invoiceOpenService;
	@Autowired
	private IInvoiceReceiveService invoiceReceiveService;
	@Autowired
	private IOrgApi orgApi;
	@RequestMapping(value = "getInvoiceOpenMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam Long contractId, @RequestParam Long orgId) {
		try {
			BigDecimal openMny = invoiceOpenService.getOpenMny(contractId, orgId);
			return CommonResponse.success(openMny);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}
	@RequestMapping(value = "getInvoiceReceiceMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam Long contractId, @RequestParam Long orgId) {
		try {
			BigDecimal openMny = invoiceReceiveService.getReceiveMny(contractId, orgId);
			return CommonResponse.success(openMny);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}
	/**
	 *
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@GetMapping("/invoiceOpenRef")
	public CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(defaultValue = "1") Integer pageNumber,
																@RequestParam(defaultValue = "10") Integer pageSize,
																@RequestParam(value = "condition", required = false) String condition,
																@RequestParam(value = "searchText", required = false) String searchText) {

		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);
		queryParam.getFuzzyFields().add("billCode");
		queryParam.getFuzzyFields().add("contractName");
		List<Integer> billstate = new ArrayList<>();
		billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
		billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
		queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
		if(StringUtils.isNotBlank(condition)) {
			Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
			if(null != conditionMap.get("orgId")) {
				Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
				queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, projectId));
			}
			if(null != conditionMap.get("contractId")) {
				Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
				queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, projectId));
			}
		}
		queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		IPage<InvoiceOpenEntity> pageData = invoiceOpenService.queryPage(queryParam,false);
		IPage<InvoiceOpenVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
		result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class));
		return CommonResponse.success("开票登记参照查询成功！", result);
	}
	/**
	 *
	 *
	 * @param queryParam
	 * @return
	 */
	@PostMapping("/invoiceReceiveRef")
	public CommonResponse<IPage<InvoiceReceiveVO>> invoiceReceiveRef(@RequestBody QueryParam queryParam) {
		IPage<InvoiceReceiveEntity> pageData = invoiceReceiveService.queryPage(queryParam,false);
		IPage<InvoiceReceiveVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
		result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceReceiveVO.class));
		return CommonResponse.success("开票登记参照查询成功！", result);
	}
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getInvoiceReceiveRecord", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam Long id) {
		InvoiceReceiveRecordVO invoiceReceiveRecordVO = invoiceReceiveService.getInvoiceReceiveRecord(id);
		return CommonResponse.success(invoiceReceiveRecordVO);
	}
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getInvoiceOpenRecord", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam Long id) {
		InvoiceOpenRecordVO invoiceOpenRecordVO = invoiceOpenService.getInvoiceOpenRecord(id);
		return CommonResponse.success(invoiceOpenRecordVO);
	}

}
