package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 合同收票表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("InvoiceOpenServiceImpl")
public class InvoiceOpenServiceImpl extends BaseServiceImpl<InvoiceOpenMapper, InvoiceOpenEntity> implements IInvoiceOpenService {
    private static final String TAX_INVOICE_OPEN_BILL_CODE = "TAX_OPEN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;
    @Override
    public CommonResponse<InvoiceOpenVO> saveOrUpdate(InvoiceOpenVO invoiceOpenVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceOpenEntity entity = null;
        if(StringUtils.isEmpty(invoiceOpenVo.getBillCode())){
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_OPEN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                invoiceOpenVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(invoiceOpenVo.getId() != null && invoiceOpenVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<InvoiceOpenEntity> lambda = Wrappers.<InvoiceOpenEntity>lambdaQuery();
            lambda.eq(InvoiceOpenEntity::getBillCode, invoiceOpenVo.getBillCode());
            lambda.eq(InvoiceOpenEntity::getTenantId, tenantId);
            lambda.ne(InvoiceOpenEntity::getId, invoiceOpenVo.getId());
            List<InvoiceOpenEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<InvoiceOpenEntity> lambda = Wrappers.<InvoiceOpenEntity>lambdaQuery();
            lambda.eq(InvoiceOpenEntity::getTenantId, tenantId);
            lambda.eq(InvoiceOpenEntity::getBillCode, invoiceOpenVo.getBillCode());
            List<InvoiceOpenEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(invoiceOpenVo, InvoiceOpenEntity.class);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, InvoiceOpenVO.class));
    }
    @Override
    public InvoiceOpenVO queryDetail(Long id) {
        InvoiceOpenEntity entity = invoiceOpenMapper.selectById(id);
        if(entity != null) {
            InvoiceOpenVO invoiceOpenVo = BeanMapper.map(entity, InvoiceOpenVO.class);
            return invoiceOpenVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceOpen(List<InvoiceOpenVO> vos) {
        super.removeByIds(vos.stream().map(InvoiceOpenVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public BigDecimal getOpenMny(Long contractId, Long orgId) {
        BigDecimal openMny = invoiceOpenMapper.getOpenMny(contractId,orgId);
        return openMny;
    }
    @Override
    public InvoiceOpenRecordVO getInvoiceOpenRecord(Long id) {
        InvoiceOpenRecordVO invoiceOpenRecordVO = new InvoiceOpenRecordVO();
        BigDecimal invoiceMny = invoiceOpenMapper.getInvoiceMny(id);//发票金额（不含税）
        BigDecimal invoiceTaxMny = invoiceOpenMapper.getInvoiceTaxMny(id);//发票金额（含税）
        BigDecimal taxMny = invoiceOpenMapper.getTaxMny(id);//税金
        invoiceOpenRecordVO.setInvoiceMny(invoiceMny == null ? BigDecimal.ZERO:invoiceMny);
        invoiceOpenRecordVO.setInvoiceTaxMny(invoiceTaxMny == null ? BigDecimal.ZERO:invoiceTaxMny);
        invoiceOpenRecordVO.setTaxMny(taxMny == null ? BigDecimal.ZERO:taxMny);
        LambdaQueryWrapper<InvoiceOpenEntity> lambda = Wrappers.<InvoiceOpenEntity>lambdaQuery();
        lambda.eq(InvoiceOpenEntity::getContractId,id);
        lambda.in(InvoiceOpenEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<InvoiceOpenEntity> entities = super.list(lambda);
        invoiceOpenRecordVO.setInvoiceOpenVOList(BeanMapper.mapList(entities, InvoiceOpenVO.class));
        return invoiceOpenRecordVO;
    }
}
