package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.mapper.InvoiceReceiveMapper;
import com.ejianc.business.tax.mapper.InvoiceReceiveMapper;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 有合同开票 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("InvoiceReceiveServiceImpl")
public class InvoiceReceiveServiceImpl extends BaseServiceImpl<InvoiceReceiveMapper, InvoiceReceiveEntity> implements IInvoiceReceiveService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceReceiveMapper invoiceReceiveMapper;
    @Override
    public CommonResponse<InvoiceReceiveVO> saveOrUpdate(InvoiceReceiveVO invoiceReceiveVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceReceiveEntity entity = null;
        if(StringUtils.isEmpty(invoiceReceiveVo.getBillCode())){
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                invoiceReceiveVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(invoiceReceiveVo.getId() != null && invoiceReceiveVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<InvoiceReceiveEntity> lambda = Wrappers.<InvoiceReceiveEntity>lambdaQuery();
            lambda.eq(InvoiceReceiveEntity::getBillCode, invoiceReceiveVo.getBillCode());
            lambda.eq(InvoiceReceiveEntity::getTenantId, tenantId);
            lambda.ne(InvoiceReceiveEntity::getId, invoiceReceiveVo.getId());
            List<InvoiceReceiveEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<InvoiceReceiveEntity> lambda = Wrappers.<InvoiceReceiveEntity>lambdaQuery();
            lambda.eq(InvoiceReceiveEntity::getTenantId, tenantId);
            lambda.eq(InvoiceReceiveEntity::getBillCode, invoiceReceiveVo.getBillCode());
            List<InvoiceReceiveEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(invoiceReceiveVo, InvoiceReceiveEntity.class);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, InvoiceReceiveVO.class));
    }
    @Override
    public InvoiceReceiveVO queryDetail(Long id) {
        InvoiceReceiveEntity entity = invoiceReceiveMapper.selectById(id);
        if(entity != null) {
            InvoiceReceiveVO invoiceReceiveVo = BeanMapper.map(entity, InvoiceReceiveVO.class);
            return invoiceReceiveVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceReceive(List<InvoiceReceiveVO> vos) {
        super.removeByIds(vos.stream().map(InvoiceReceiveVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public BigDecimal getReceiveMny(Long contractId, Long orgId) {
        BigDecimal receiveMny = invoiceReceiveMapper.getReceiveMny(contractId,orgId);
        return receiveMny;
    }

    @Override
    public InvoiceReceiveRecordVO getInvoiceReceiveRecord(Long id) {
        InvoiceReceiveRecordVO invoiceReceiveRecordVO = new InvoiceReceiveRecordVO();
        BigDecimal invoiceMny = invoiceReceiveMapper.getInvoiceMny(id);//发票金额（不含税）
        BigDecimal invoiceTaxMny = invoiceReceiveMapper.getInvoiceTaxMny(id);//发票金额（含税）
        BigDecimal taxMny = invoiceReceiveMapper.getTaxMny(id);//税金
        invoiceReceiveRecordVO.setInvoiceMny(invoiceMny == null ? BigDecimal.ZERO:invoiceMny);
        invoiceReceiveRecordVO.setInvoiceTaxMny(invoiceTaxMny == null ? BigDecimal.ZERO:invoiceTaxMny);
        invoiceReceiveRecordVO.setTaxMny(taxMny == null ? BigDecimal.ZERO:taxMny);
        LambdaQueryWrapper<InvoiceReceiveEntity> lambda = Wrappers.<InvoiceReceiveEntity>lambdaQuery();
        lambda.eq(InvoiceReceiveEntity::getContractId,id);
        lambda.in(InvoiceReceiveEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<InvoiceReceiveEntity> entities = super.list(lambda);
        invoiceReceiveRecordVO.setInvoiceReceiveVOList(BeanMapper.mapList(entities, InvoiceReceiveVO.class));
        return invoiceReceiveRecordVO;
    }
}
