/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.mapper.InvoiceReceiveMapper;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="InvoiceReceiveService")
public class InvoiceReceiveServiceImpl
extends BaseServiceImpl<InvoiceReceiveMapper, InvoiceReceiveEntity>
implements IInvoiceReceiveService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceReceiveMapper invoiceReceiveMapper;

    @Override
    public CommonResponse<InvoiceReceiveVO> saveOrUpdate(InvoiceReceiveVO invoiceReceiveVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceReceiveEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)invoiceReceiveVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                invoiceReceiveVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (invoiceReceiveVo.getId() != null && invoiceReceiveVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(InvoiceReceiveEntity::getBillCode, (Object)invoiceReceiveVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)invoiceReceiveVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(InvoiceReceiveEntity::getBillCode, (Object)invoiceReceiveVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (InvoiceReceiveEntity)((Object)BeanMapper.map((Object)invoiceReceiveVo, InvoiceReceiveEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), InvoiceReceiveVO.class));
    }

    @Override
    public InvoiceReceiveVO queryDetail(Long id) {
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveMapper.selectById(id));
        if (entity != null) {
            InvoiceReceiveVO invoiceReceiveVo = (InvoiceReceiveVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveVO.class);
            return invoiceReceiveVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceReceive(List<InvoiceReceiveVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public BigDecimal getReceiveMny(Long contractId, Long orgId) {
        BigDecimal receiveMny = this.invoiceReceiveMapper.getReceiveMny(contractId, orgId);
        return receiveMny;
    }

    @Override
    public InvoiceReceiveRecordVO getInvoiceReceiveRecord(Long id) {
        InvoiceReceiveRecordVO invoiceReceiveRecordVO = new InvoiceReceiveRecordVO();
        invoiceReceiveRecordVO.setContractId(id);
        BigDecimal invoiceMny = this.invoiceReceiveMapper.getInvoiceMny(id);
        BigDecimal invoiceTaxMny = this.invoiceReceiveMapper.getInvoiceTaxMny(id);
        BigDecimal taxMny = this.invoiceReceiveMapper.getTaxMny(id);
        invoiceReceiveRecordVO.setInvoiceMny(invoiceMny == null ? BigDecimal.ZERO : invoiceMny);
        invoiceReceiveRecordVO.setInvoiceTaxMny(invoiceTaxMny == null ? BigDecimal.ZERO : invoiceTaxMny);
        invoiceReceiveRecordVO.setTaxMny(taxMny == null ? BigDecimal.ZERO : taxMny);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(InvoiceReceiveEntity::getContractId, (Object)id);
        lambda.in(InvoiceReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List list = BeanMapper.mapList((Iterable)entities, InvoiceReceiveVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
            invoiceReceiveRecordVO.setInvoiceReceiveVOList(list);
        }
        return invoiceReceiveRecordVO;
    }
}

