/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.mapper.InvoiceReceiveMapper;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="InvoiceReceiveService")
public class InvoiceReceiveServiceImpl
extends BaseServiceImpl<InvoiceReceiveMapper, InvoiceReceiveEntity>
implements IInvoiceReceiveService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceReceiveMapper invoiceReceiveMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<InvoiceReceiveVO> saveOrUpdate(InvoiceReceiveVO invoiceReceiveVo) {
        List entities;
        LambdaQueryWrapper lambda;
        block17: {
            if (invoiceReceiveVo.getContractVersion() != null && invoiceReceiveVo.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(invoiceReceiveVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        JSONObject contractEntity = this.commenQueryFieldsService.queryBillDetail(String.valueOf(invoiceReceiveVo.getContractId()), this.getBillTypeCode(invoiceReceiveVo.getContractType()));
                        String objVersion = contractEntity.getJSONObject("data").get((Object)"version").toString();
                        Integer version = contractEntity.getJSONObject("data").get((Object)"version") == null ? 0 : Integer.parseInt(objVersion.substring(0, objVersion.indexOf(".")));
                        if (!version.equals(conVersion = invoiceReceiveVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block17;
                    }
                    CommonResponse contractEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(invoiceReceiveVo.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceReceiveEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)invoiceReceiveVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                invoiceReceiveVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (invoiceReceiveVo.getId() != null && invoiceReceiveVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(InvoiceReceiveEntity::getBillCode, (Object)invoiceReceiveVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)invoiceReceiveVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(InvoiceReceiveEntity::getBillCode, (Object)invoiceReceiveVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (InvoiceReceiveEntity)((Object)BeanMapper.map((Object)invoiceReceiveVo, InvoiceReceiveEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), InvoiceReceiveVO.class));
    }

    @Override
    public InvoiceReceiveVO queryDetail(Long id) {
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveMapper.selectById(id));
        if (entity != null) {
            InvoiceReceiveVO invoiceReceiveVo = (InvoiceReceiveVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveVO.class);
            return invoiceReceiveVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceReceive(List<InvoiceReceiveVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public BigDecimal getReceiveMny(Long contractId, Long orgId) {
        BigDecimal receiveMny = this.invoiceReceiveMapper.getReceiveMny(contractId, orgId);
        return receiveMny;
    }

    @Override
    public InvoiceReceiveRecordVO getInvoiceReceiveRecord(Long id) {
        InvoiceReceiveRecordVO invoiceReceiveRecordVO = new InvoiceReceiveRecordVO();
        invoiceReceiveRecordVO.setContractId(id);
        List longList = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(InvoiceReceiveEntity::getContractId, (Object)id);
        lambda.in(InvoiceReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(InvoiceReceiveEntity::getOrgId, longList);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List list = BeanMapper.mapList((Iterable)entities, InvoiceReceiveVO.class);
            BigDecimal invoiceMny = BigDecimal.ZERO;
            BigDecimal invoiceTaxMny = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            for (InvoiceReceiveVO invoiceReceiveVO : list) {
                invoiceReceiveVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)invoiceReceiveVO.getBillState()).getDescription());
                invoiceMny = invoiceMny.add(invoiceReceiveVO.getInvoiceMny());
                invoiceTaxMny = invoiceTaxMny.add(invoiceReceiveVO.getInvoiceTaxMny());
                taxMny = taxMny.add(invoiceReceiveVO.getTaxMny());
            }
            invoiceReceiveRecordVO.setInvoiceMny(invoiceMny);
            invoiceReceiveRecordVO.setInvoiceTaxMny(invoiceTaxMny);
            invoiceReceiveRecordVO.setTaxMny(taxMny);
            invoiceReceiveRecordVO.setInvoiceReceiveVOList(list);
        }
        return invoiceReceiveRecordVO;
    }

    @Override
    public CommonResponse<String> updateFlag(List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS) {
        List list = BeanMapper.mapList(invoiceReceiveFlagVOS, InvoiceReceiveEntity.class);
        boolean b = super.saveOrUpdateBatch((Collection)list);
        if (b) {
            return CommonResponse.success((String)"\u4fee\u6539\u6536\u7968\u5f15\u7528\u6807\u8bc6\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u4fee\u6539\u6536\u7968\u5f15\u7528\u6807\u8bc6\u5931\u8d25\uff01");
    }

    public String getBillTypeCode(String contractType) {
        if ("1".equals(contractType)) {
            return "BT200529000000001";
        }
        if ("2".equals(contractType)) {
            return "BT200528000000001";
        }
        if ("3".equals(contractType)) {
            return "BT200528000000003";
        }
        if ("4".equals(contractType)) {
            return "BT200608000000001";
        }
        if ("5".equals(contractType)) {
            return "BT200608000000001";
        }
        return "";
    }
}

