package com.ejianc.business.tax.service.impl;

import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("invoiceOpen")
public class InvoiceOpenBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票审批同意后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);
        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()) {
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), true);
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        return CommonResponse.success();

    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票撤回后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);
        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()){
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), false);
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        return CommonResponse.success();
    }

}
