package com.ejianc.business.tax.mapper;

import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 有合同开票 Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Mapper
public interface InvoiceReceiveMapper extends BaseCrudMapper<InvoiceReceiveEntity> {

    @Select("SELECT sum(r.invoice_tax_mny)  from ejc_tax_invoice_receive r WHERE r.contract_id = #{contractId} and r.org_id = #{orgId} and bill_state in (1,3) and dr = 0" )
    BigDecimal getReceiveMny(@Param("contractId")Long contractId, @Param("orgId")Long orgId);

    @Select("SELECT sum(r.invoice_mny)  from ejc_tax_invoice_receive r WHERE r.contract_id = #{id} and bill_state in (1,3) and and org_id in (ids) and dr = 0")
    BigDecimal getInvoiceMny(@Param("id")Long id, @Param("ids")List<Long> ids);

    @Select("SELECT sum(r.invoice_tax_mny)  from ejc_tax_invoice_receive r WHERE r.contract_id = #{id} and bill_state in (1,3) and dr = 0")
    BigDecimal getInvoiceTaxMny(Long id);

    @Select("SELECT sum(r.tax_mny)  from ejc_tax_invoice_receive r WHERE r.contract_id = #{id} and bill_state in (1,3) and dr = 0")
    BigDecimal getTaxMny(Long id);
}
