package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.vo.InvoiceOpenApplyVO;

/**
 * 开票申请
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceOpenApply")
public class InvoiceOpenApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IInvoiceOpenApplyService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceOpenRegistService iInvoiceOpenRegistService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceOpenApplyVO> saveOrUpdate(@RequestBody InvoiceOpenApplyVO saveorUpdateVO) {
    	InvoiceOpenApplyEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceOpenApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

    	InvoiceOpenApplyVO vo = BeanMapper.map(entity, InvoiceOpenApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenApplyVO> queryDetail(Long id) {
    	InvoiceOpenApplyEntity entity = service.selectById(id);
    	InvoiceOpenApplyVO vo = BeanMapper.map(entity, InvoiceOpenApplyVO.class);
      /*  InvoiceOpenApplyEntity invoiceOpenApplyEntity =service.getById(id);
        iInvoiceOpenRegistService.save(invoiceOpenApplyEntity);*/
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenApplyVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceOpenApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("buyer");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<InvoiceOpenApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOpenList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenApplyVO>> queryOpenList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("openType", new Parameter(QueryParam.EQ, 1));

        IPage<InvoiceOpenApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
