package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;

/**
 * 收票登记
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceReceiveRegist")
public class InvoiceReceiveRegistController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-code-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
    	InvoiceReceiveRegistEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceiveRegistEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity);
    	InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
    	InvoiceReceiveRegistEntity entity = service.selectById(id);
    	InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceiveRegistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询进项发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
