package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import org.springframework.transaction.annotation.Transactional;

import java.beans.Transient;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity> implements IInvoiceOpenRegistService{
     @Autowired
     private IInvoiceOpenPoolService invoiceOpenPoolService;
     @Autowired
     private IInvoiceOpenApplyService invoiceOpenApplyService;

     private Lock lock = new ReentrantLock(true);

    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());

        registEntity.setBillState(invoiceOpenApplyEntity.getBillState());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());

        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());

        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        super.save(registEntity);
    }

    /**
     * 保存（同时添加到发票池中）
     * @param invoiceOpenRegistEntity
     */
    @Transactional
    public void saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        lock.lock();
        try {
            if(invoiceOpenRegistEntity.getId() != null){
                InvoiceOpenRegistEntity entity =getById(invoiceOpenRegistEntity.getId());
                if(entity.getRegistType() == 1){

                    throw new BusinessException("该单据已经登记 无需重新登记！");
                }
                entity.setRegistUserId(invoiceOpenRegistEntity.getRegistUserId());
                entity.setRegistDate(invoiceOpenRegistEntity.getRegistDate());
                entity.setRegistUserName(invoiceOpenRegistEntity.getRegistUserName());
                entity.setRegistType(1);
                if(CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
                    List<InvoiceOpenPoolEntity> list =invoiceOpenRegistEntity.getContractItemList();
                    for (InvoiceOpenPoolEntity v : list){
                        InvoiceOpenPoolEntity invoiceOpenPoolEntity = new InvoiceOpenPoolEntity();
                        invoiceOpenPoolEntity.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        invoiceOpenPoolEntity.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        invoiceOpenPoolEntity.setContractId(invoiceOpenRegistEntity.getContractId());
                        invoiceOpenPoolEntity.setCustomerName(invoiceOpenRegistEntity.getContractName());
                        invoiceOpenPoolEntity.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                        invoiceOpenPoolEntity.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                        invoiceOpenPoolEntity.setEmployeeId(invoiceOpenRegistEntity.getApplyerId());
                        invoiceOpenPoolEntity.setEmployeeName(invoiceOpenRegistEntity.getApplyer());
                        invoiceOpenPoolEntity.setOrgId(invoiceOpenRegistEntity.getOrgId());
                        invoiceOpenPoolEntity.setProjectId(invoiceOpenRegistEntity.getProjectId());
                        invoiceOpenPoolEntity.setProjectName(invoiceOpenRegistEntity.getProjectName());
                        //invoiceOpenPoolEntity.setRegistCode(invoiceOpenRegistEntity.getApplyCode());
                        invoiceOpenPoolEntity.setRegistId(invoiceOpenRegistEntity.getId());
                        invoiceOpenPoolEntity.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                        invoiceOpenPoolEntity.setSupplierName(invoiceOpenRegistEntity.getSeller());
                        invoiceOpenPoolEntity.setSupplierId(invoiceOpenRegistEntity.getSellerId());

                        invoiceOpenPoolEntity.setInvoiceCode(v.getInvoiceCode());
                        invoiceOpenPoolEntity.setInvoiceContent(v.getInvoiceContent());
                        invoiceOpenPoolEntity.setInvoiceDate(v.getInvoiceDate());
                        invoiceOpenPoolEntity.setInvoiceMny(v.getInvoiceMny());
                        invoiceOpenPoolEntity.setInvoiceNumber(v.getInvoiceNumber());
                        invoiceOpenPoolEntity.setInvoiceTaxMny(v.getInvoiceTaxMny());
                        invoiceOpenPoolEntity.setInvoiceTaxMnyChn(v.getInvoiceTaxMnyChn());
                        invoiceOpenPoolEntity.setMemo(v.getMemo());
                        invoiceOpenPoolEntity.setTaxMny(v.getTaxMny());
                        invoiceOpenPoolService.save(invoiceOpenPoolEntity);
                    }
                    super.updateById(entity);
                    UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
                    wrapper.eq("id",entity.getApplyId());
                    wrapper.set("open_type",1);
                    invoiceOpenApplyService.update(wrapper);
                }
            }
        }catch (Exception e){
            //e.printStackTrace();
        }finally {
            //释放锁
            lock.unlock();
        }

    }

    /**
     * 根据id查询带出 发票池数据
     * @param id
     * @return
     */
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity =this.getById(id);

        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id" ,id);
        List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.list(queryWrapper);
        entity.setContractItemList(list);

        return entity;
    }
}
