package com.ejianc.business.taxnew.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceReceivePoolMapper;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;

import java.util.List;

/**
 * 进项发票池
 * 
 * @author generator
 * 
 */
@Service("invoiceReceivePoolService")
public class InvoiceReceivePoolServiceImpl extends BaseServiceImpl<InvoiceReceivePoolMapper, InvoiceReceivePoolEntity> implements IInvoiceReceivePoolService{
    @Autowired
    InvoiceReceivePoolMapper mapper;
    /**
     * 更新指定发票状态
     *
     * @param ids
     * @param state // 是否被抵扣引用(1:是，0：否)
     */
    @Override
    public void updateInvoiceReceivePoolEntityUseState(List<Long> ids, Integer state) {
        mapper.updateInvoiceReceivePoolEntityUseState(ids,state);
    }

    /**
     * 更新指定发票 抵扣申请单id
     *
     * @param ids
     * @param applyId
     */
    @Override
    public void updateInvoiceReceivePoolEntityDeducApplyIds(List<Long> ids, Long applyId) {
        mapper.updateInvoiceReceivePoolEntityDeducApplyIds(ids,applyId);
    }
}
