/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.vo.InvoiceDeducApplySubVO;
import com.ejianc.business.taxnew.vo.InvoiceDeducApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceDeducApply"})
public class InvoiceDeducApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceDeducApplySubService invoiceDeducApplySubService;
    @Autowired
    private IInvoiceReceivePoolService iInvoiceReceivePoolService;
    private static final String BILL_CODE = "tax-deduc-apply-001";
    @Autowired
    private IInvoiceDeducApplyService service;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceDeducApplyVO> saveOrUpdate(@RequestBody InvoiceDeducApplyVO saveorUpdateVO) {
        InvoiceDeducApplyEntity entity = (InvoiceDeducApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceDeducApplyEntity.class));
        ArrayList<Long> oldInvoiceIds = new ArrayList<Long>();
        ArrayList<Long> newInvoiceIds = new ArrayList<Long>();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)billCode.getData());
        } else {
            InvoiceDeducApplyEntity db = (InvoiceDeducApplyEntity)((Object)this.service.selectById(entity.getId()));
            for (InvoiceDeducApplySubEntity sub : db.getDeducApplySubs()) {
                oldInvoiceIds.add(sub.getInvoiceId());
            }
        }
        if (!ListUtil.isNotEmpty(entity.getDeducApplySubs())) throw new BusinessException("\u5fc5\u987b\u6dfb\u52a0\u53d1\u7968\uff01");
        QueryParam param = new QueryParam();
        for (InvoiceDeducApplySubEntity sub : entity.getDeducApplySubs()) {
            List entities;
            if (sub.getInvoiceId() == null) {
                throw new BusinessException("\u5b50\u8868\u53d1\u7968\u4ee3\u7801\uff1a\u3010" + sub.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\uff1a\u3010" + sub.getInvoiceNumber() + "\u3011\u7684\u53d1\u7968id\u3010invoiceId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            newInvoiceIds.add(sub.getInvoiceId());
            if ("add".equals(sub.getRowState())) {
                param.getParams().put("invoiceCode", new Parameter("eq", (Object)sub.getInvoiceCode()));
                param.getParams().put("invoiceNumber", new Parameter("eq", (Object)sub.getInvoiceNumber()));
                entities = this.invoiceDeducApplySubService.queryList(param);
                if (!ListUtil.isNotEmpty((List)entities)) continue;
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u53d1\u7968\uff01\u53d1\u7968\u4ee3\u7801\uff1a\u3010" + sub.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\uff1a\u3010" + sub.getInvoiceNumber() + "\u3011");
            }
            if ("del".equals(sub.getRowState())) continue;
            param.getParams().put("invoiceCode", new Parameter("eq", (Object)sub.getInvoiceCode()));
            param.getParams().put("invoiceNumber", new Parameter("eq", (Object)sub.getInvoiceNumber()));
            entities = this.invoiceDeducApplySubService.queryList(param);
            if (!ListUtil.isNotEmpty((List)entities) || entities.size() <= 1 && ((InvoiceDeducApplySubEntity)((Object)entities.get(0))).getId().equals(entity.getId())) continue;
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u53d1\u7968\uff01\u53d1\u7968\u4ee3\u7801\uff1a\u3010" + sub.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\uff1a\u3010" + sub.getInvoiceNumber() + "\u3011");
        }
        this.service.saveOrUpdateNoES((Object)entity);
        this.iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityUseState(oldInvoiceIds, 0);
        this.iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityUseState(newInvoiceIds, 1);
        this.iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityDeducApplyIds(oldInvoiceIds, null);
        this.iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityDeducApplyIds(newInvoiceIds, entity.getId());
        InvoiceDeducApplyVO vo = (InvoiceDeducApplyVO)BeanMapper.map((Object)((Object)entity), InvoiceDeducApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceDeducApplyVO> queryDetail(Long id) {
        InvoiceDeducApplyEntity entity = (InvoiceDeducApplyEntity)((Object)this.service.selectById(id));
        InvoiceDeducApplyVO vo = (InvoiceDeducApplyVO)BeanMapper.map((Object)((Object)entity), InvoiceDeducApplyVO.class);
        for (InvoiceDeducApplySubVO sub : vo.getDeducApplySubs()) {
            InvoiceReceivePoolEntity invoice = (InvoiceReceivePoolEntity)((Object)this.iInvoiceReceivePoolService.selectById(sub.getInvoiceId()));
            sub.setAuthState(invoice.getAuthState());
            sub.setAuthDescription(invoice.getAuthState() == 0 ? "\u672a\u8ba4\u8bc1" : (invoice.getAuthState() == 1 ? "\u8ba4\u8bc1\u6210\u529f" : "\u8ba4\u8bc1\u5931\u8d25"));
            if (invoice.getAuthState() == 0 || invoice.getAuthState() == 2) {
                sub.setCanDeduc("\u5426");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)sub.getCanDeduc())) continue;
            sub.setCanDeduc("\u662f");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceDeducApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryToProcessList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> queryToProcessList(@RequestBody QueryParam param) {
        param.getParams().put("deducBillId", new Parameter("eq", null));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        return this.queryList(param);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvoiceDeducApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvoiceDeducApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> refInvoiceDeducApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

