/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceOpenRegist"})
public class InvoiceOpenRegistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceOpenRegistService service;
    @Autowired
    private IInvoiceOpenPoolService iInvoiceOpenPoolService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> saveOrUpdate(@RequestBody InvoiceOpenRegistVO saveorUpdateVO) {
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceOpenRegistEntity.class));
        InvoiceOpenRegistEntity registEntity = this.service.saveOrUpdatePool(entity);
        InvoiceOpenRegistVO vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)registEntity), InvoiceOpenRegistVO.class);
        List list = vo.getContractItemList();
        ArrayList<InvoiceOpenPoolVO> allList = new ArrayList<InvoiceOpenPoolVO>();
        for (InvoiceOpenPoolVO v : list) {
            v.setRowState(null);
            allList.add(v);
        }
        vo.setContractItemList(allList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryDetail(Long id) {
        InvoiceOpenRegistEntity entity = this.service.selectByIdAll(id);
        InvoiceOpenRegistVO vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenRegistVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenRegistVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceOpenRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRegistPool"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryPoolList(Long id) {
        InvoiceOpenRegistEntity entity = this.service.selectOpenRegistByApplyId(id);
        InvoiceOpenRegistVO vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u5f00\u7968\u767b\u8bb0\u5bfc\u5165\u6a21\u677f");
    }
}

