/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceReceivePool"})
public class InvoiceReceivePoolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-pool-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceReceivePoolService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceReceiveRegistService registService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> saveOrUpdate(@RequestBody InvoiceReceivePoolVO saveorUpdateVO) {
        InvoiceReceivePoolEntity entity = (InvoiceReceivePoolEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceReceivePoolEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdateNoES((Object)entity);
        InvoiceReceivePoolVO vo = (InvoiceReceivePoolVO)BeanMapper.map((Object)((Object)entity), InvoiceReceivePoolVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> queryDetail(Long id) {
        InvoiceReceivePoolEntity entity = (InvoiceReceivePoolEntity)((Object)this.service.selectById(id));
        InvoiceReceivePoolVO vo = (InvoiceReceivePoolVO)BeanMapper.map((Object)((Object)entity), InvoiceReceivePoolVO.class);
        if (vo.getReceiveBillId() != null) {
            InvoiceReceiveRegistVO info = (InvoiceReceiveRegistVO)BeanMapper.map((Object)this.registService.selectById(vo.getReceiveBillId()), InvoiceReceiveRegistVO.class);
            vo.setReceiveRegistInfo(info);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceivePoolVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("receiveBillId", new Parameter("ne", null));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refInvoiceReceivePoolData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> refInvoiceReceivePoolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("receiveBillId", new Parameter("ne", null));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.getLong("projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
            }
            if (_con.getLong("flag") != null) {
                param.getParams().put("flag", new Parameter("eq", (Object)_con.getLong("flag")));
            }
            if (_con.getLong("deductionBillId") != null) {
                ComplexParam complexParam = new ComplexParam();
                complexParam.setLogic("or");
                complexParam.getParams().put("deductionBillId", new Parameter("eq", (Object)_con.getLong("deductionBillId")));
                param.getComplexParams().add(complexParam);
            }
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

