/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl
extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity>
implements IInvoiceOpenRegistService {
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private IInvoiceOpenApplyService invoiceOpenApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Lock lock = new ReentrantLock(true);
    private static final String BILL_CODE = "tax-open-regist-001";
    private static final String BILL_POOL_CODE = "tax-open-pool-001";
    @Autowired
    private InvoiceOpenRegistMapper invoiceOpenRegistMapper;

    @Override
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBillState(invoiceOpenApplyEntity.getBillState());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);
        String billCode = this.getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save((Object)registEntity);
    }

    @Override
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        this.lock.lock();
        try {
            ArrayList<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if (CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {
                List<InvoiceOpenPoolEntity> list = invoiceOpenRegistEntity.getContractItemList();
                for (InvoiceOpenPoolEntity pool : list) {
                    if (StringUtils.isNotEmpty((CharSequence)pool.getRowState()) && pool.getRowState().equals("del")) {
                        this.invoiceOpenPoolService.removeById(pool.getId());
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)pool.getRowState()) || pool.getRowState().equals("edit")) {
                        this.invoiceOpenPoolService.updateById((Object)pool);
                        invoiceOpenPoolEntities.add(pool);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)pool.getRowState()) || !pool.getRowState().equals("add")) continue;
                    pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                    pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                    pool.setContractId(invoiceOpenRegistEntity.getContractId());
                    pool.setContractName(invoiceOpenRegistEntity.getContractName());
                    pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                    pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                    pool.setEmployeeId(invoiceOpenRegistEntity.getApplyerId());
                    pool.setEmployeeName(invoiceOpenRegistEntity.getApplyer());
                    pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                    pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                    pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                    pool.setRegistId(invoiceOpenRegistEntity.getId());
                    pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                    pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                    pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                    String billCode = this.getBillCode(BILL_POOL_CODE);
                    pool.setBillCode(billCode);
                    pool.setType(invoiceOpenRegistEntity.getRegistOpenType());
                    this.invoiceOpenPoolService.save((Object)pool);
                    invoiceOpenPoolEntities.add(pool);
                }
                invoiceOpenRegistEntity.setRegistState(1);
                if (invoiceOpenRegistEntity.getId() != null) {
                    super.updateById((Object)invoiceOpenRegistEntity);
                    if (invoiceOpenRegistEntity.getApplyId() != null) {
                        UpdateWrapper wrapper = new UpdateWrapper();
                        wrapper.eq((Object)"id", (Object)invoiceOpenRegistEntity.getApplyId());
                        wrapper.set((Object)"open_type", (Object)1);
                        this.invoiceOpenApplyService.update((Wrapper)wrapper);
                    }
                } else {
                    String billCode = this.getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    super.save((Object)invoiceOpenRegistEntity);
                }
                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38!");
        }
        finally {
            this.lock.unlock();
        }
        return invoiceOpenRegistEntity;
    }

    public String getBillCode(String code) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)this.getById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)id);
        List list = this.invoiceOpenPoolService.list((Wrapper)queryWrapper);
        entity.setContractItemList(list);
        return entity;
    }

    @Override
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"apply_id", (Object)applyId);
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)this.invoiceOpenRegistMapper.selectOne((Wrapper)queryWrapper));
        if (entity != null) {
            // empty if block
        }
        return entity;
    }
}

