/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl
extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity>
implements IInvoiceReceiveRegistService {
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;

    @Override
    @Transactional
    public boolean saveOrUpdate(InvoiceReceiveRegistEntity entity) {
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            QueryParam param = new QueryParam();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                List list;
                if ("add".equals(poolEntity.getRowState())) {
                    param.getParams().put("invoiceCode", new Parameter("eq", (Object)poolEntity.getInvoiceCode()));
                    param.getParams().put("invoiceNumber", new Parameter("eq", (Object)poolEntity.getInvoiceNumber()));
                    list = this.invoiceReceivePoolService.queryList(param);
                    if (ListUtil.isNotEmpty((List)list)) {
                        throw new BusinessException("\u53d1\u7968\uff1a\u4ee3\u7801\u3010" + poolEntity.getInvoiceCode() + "\u3011\uff0c\u53f7\u7801\u3010" + poolEntity.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)poolEntity));
                    poolEntity.setId(null);
                } else if (!"del".equals(poolEntity.getRowState())) {
                    param.getParams().put("invoiceCode", new Parameter("eq", (Object)poolEntity.getInvoiceCode()));
                    param.getParams().put("invoiceNumber", new Parameter("eq", (Object)poolEntity.getInvoiceNumber()));
                    list = this.invoiceReceivePoolService.queryList(param);
                    if (ListUtil.isNotEmpty((List)list) && ((InvoiceReceivePoolEntity)((Object)list.get(0))).getReceiveBillId() != null && !((InvoiceReceivePoolEntity)((Object)list.get(0))).getReceiveBillId().equals(entity.getId())) {
                        throw new BusinessException("\u53d1\u7968\uff1a\u4ee3\u7801\u3010" + poolEntity.getInvoiceCode() + "\u3011\uff0c\u53f7\u7801\u3010" + poolEntity.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                }
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
            }
        }
        return super.saveOrUpdateNoES((Object)entity);
    }
}

