package com.ejianc.business.taxnew.service;

import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
public interface IInvoiceOpenRegistService extends IBaseService<InvoiceOpenRegistEntity> {
    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity);

    /**
     * 保存或者修改（同时插入到发票池）
     * @param invoiceOpenRegistEntity
     */
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity);

    public InvoiceOpenRegistEntity selectByIdAll(Long id);

    /**
     * 根据申请id查一条登记
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId);

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date);

}
