package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;

import java.util.List;

/**
 * 销项发票池
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenPoolService")
public class InvoiceOpenPoolServiceImpl extends BaseServiceImpl<InvoiceOpenPoolMapper, InvoiceOpenPoolEntity> implements IInvoiceOpenPoolService{
     @Autowired
     private InvoiceOpenPoolMapper invoiceOpenPoolMapper;
    /**
     * 根据注册id删除
     * @param registId
     */
    public void deleteRegistId(Long registId) {
        QueryWrapper<InvoiceOpenPoolEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("regist_id", registId);
        invoiceOpenPoolMapper.delete(deleteWrapper);
    }

    @Override
    public List<InvoiceOpenPoolEntity> queryRegistById(Long registId) {
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("regist_id", registId);
        queryWrapper.eq("dr","0");
        return invoiceOpenPoolMapper.selectList(queryWrapper);
    }
}
