package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import org.springframework.transaction.annotation.Transactional;

import java.beans.Transient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity> implements IInvoiceOpenRegistService{
     @Autowired
     private IInvoiceOpenPoolService invoiceOpenPoolService;
     @Autowired
     private IInvoiceOpenApplyService invoiceOpenApplyService;
     @Autowired
     private IBillCodeApi billCodeApi;

     private Lock lock = new ReentrantLock(true);
     private static final String BILL_CODE = "tax-open-regist-001";
     private static final String BILL_POOL_CODE = "tax-open-pool-001";

     @Autowired
     private InvoiceOpenRegistMapper invoiceOpenRegistMapper;

    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    @Transactional
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("dr","0");
        queryWrapper.eq("apply_id" ,invoiceOpenApplyEntity.getId());
        List<InvoiceOpenApplyEntity> invoiceOpenApplyList =super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(invoiceOpenApplyList)){
            throw new BusinessException("不可以重复提交");
        }
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBillState(invoiceOpenApplyEntity.getBillState());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        //registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setOrgName(invoiceOpenApplyEntity.getOrgName());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);//有申请
        registEntity.setRegistState(0);//待登记
        String billCode =getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save(registEntity);
    }

    /**
     * 保存（同时添加到发票池中）
     * @param invoiceOpenRegistEntity
     */
    @Transactional
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        lock.lock();
        try {
            List<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if(CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
                List<InvoiceOpenPoolEntity> list =invoiceOpenRegistEntity.getContractItemList();
                for (InvoiceOpenPoolEntity pool : list){
                    if (StringUtils.isNotEmpty(pool.getRowState())  && pool.getRowState().equals("del")){
                        invoiceOpenPoolService.removeById(pool.getId());
                    }else if(StringUtils.isEmpty(pool.getRowState())  || pool.getRowState().equals("edit")){
                        invoiceOpenPoolService.updateById(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }else if (StringUtils.isNotEmpty(pool.getRowState())  && pool.getRowState().equals("add")){
                        if(invoiceOpenRegistEntity.getApplyId() != null){
                            pool.setOpenApplyType(1);//有申请
                        }
                        pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
                        pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        pool.setContractId(invoiceOpenRegistEntity.getContractId());
                        pool.setContractName(invoiceOpenRegistEntity.getContractName());
                        pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                        pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                        pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
                        pool.setEmployeeId(invoiceOpenRegistEntity.getApplyerId());
                        pool.setEmployeeName(invoiceOpenRegistEntity.getApplyer());
                        pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                        pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
                        pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                        pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                        //invoiceOpenPoolEntity.setRegistCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setRegistId(invoiceOpenRegistEntity.getId());
                        pool.setRegistCode(invoiceOpenRegistEntity.getCode());
                        pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                        pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                        pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                        String billCode =getBillCode(BILL_POOL_CODE);
                        pool.setBillCode(billCode);
                        pool.setType(invoiceOpenRegistEntity.getRegistOpenType());
                        invoiceOpenPoolService.save(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }
                }

                //后期加参数在控制
                if (invoiceOpenRegistEntity.getId() != null){
                    //有开票申请
                    super.updateById(invoiceOpenRegistEntity);
                    //同时修改开票申请开票状态
                    if(invoiceOpenRegistEntity.getApplyId() != null){
                        invoiceOpenRegistEntity.setRegistState(1);
                        UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
                        wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
                        wrapper.set("open_type",1);
                        invoiceOpenApplyService.update(wrapper);
                    }
                }else{
                    String billCode =getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    //无开票申请直接保存
                    super.save(invoiceOpenRegistEntity);
                }
                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);

            }

        }catch (Exception e){
            throw new BusinessException("系统异常!");
        }finally {
            lock.unlock(); //释放锁
        }

        return invoiceOpenRegistEntity;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 根据id查询带出 发票池数据
     * @param id
     * @return
     */
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity =this.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id" ,id);
        List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.list(queryWrapper);
        entity.setContractItemList(list);
        return entity;
    }

    /**
     * 根据申请id查询一条数据
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("apply_id" ,applyId);
        InvoiceOpenRegistEntity entity =invoiceOpenRegistMapper.selectOne(queryWrapper);
        if(entity != null){
            QueryParam param = new QueryParam();
            param.getParams().put("registId",new Parameter(QueryParam.EQ,entity.getId()));
            List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                entity.setContractItemList(list);
            }
        }
        return entity;
    }

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date) {
        if(date.length() == 5){
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DoubleToDate(Double.parseDouble(date));
                return sdf.format(tDate);
            }catch (Exception e){
                e.printStackTrace();
                return date;
            }
        }
        return date;
    }

    //解析Excel日期格式
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));
        return tDate;
    }
}
