package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import org.springframework.transaction.annotation.Transactional;

import java.beans.Transient;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity> implements IInvoiceOpenRegistService{
     @Autowired
     private IInvoiceOpenPoolService invoiceOpenPoolService;
     @Autowired
     private IInvoiceOpenApplyService invoiceOpenApplyService;
     @Autowired
     private IBillCodeApi billCodeApi;

     private Lock lock = new ReentrantLock(true);
     private static final String BILL_CODE = "tax-open-regist-001";
     private static final String BILL_POOL_CODE = "tax-open-pool-001";

     @Autowired
     private InvoiceOpenRegistMapper invoiceOpenRegistMapper;

    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    @Transactional
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("dr","0");
        queryWrapper.eq("apply_id" ,invoiceOpenApplyEntity.getId());
        List<InvoiceOpenApplyEntity> invoiceOpenApplyList =super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(invoiceOpenApplyList)){
            throw new BusinessException("不可以重复提交");
        }
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        //registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setOrgName(invoiceOpenApplyEntity.getOrgName());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setSellerAddrPhone(invoiceOpenApplyEntity.getSellerAddrPhone());
        registEntity.setSellerBankAccount(invoiceOpenApplyEntity.getSellerBankAccount());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);//有申请
        registEntity.setRegistState(0);//待登记
        registEntity.setHasContract(invoiceOpenApplyEntity.getHasContract()); //是否有合同
        registEntity.setNowContractMny(invoiceOpenApplyEntity.getNowContractMny());
        registEntity.setTotalQuoteMny(invoiceOpenApplyEntity.getTotalQuoteMny());
        registEntity.setTotalOpenApplyMnyTax(invoiceOpenApplyEntity.getTotalOpenApplyMnyTax());
        registEntity.setTotalOpenMny(invoiceOpenApplyEntity.getTotalOpenMny());
        registEntity.setTotalBackMnyTax(invoiceOpenApplyEntity.getTotalBackMnyTax());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        String billCode =getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save(registEntity);
    }

    /**
     * 保存（同时添加到发票池中）
     * @param invoiceOpenRegistEntity
     */
    @Transactional
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        lock.lock();
        try {
            List<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if(CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
                List<InvoiceOpenPoolEntity> invoiceOpenPoolList =invoiceOpenRegistEntity.getContractItemList();
                checkPool(invoiceOpenPoolList);
                int invoiceAuantity = invoiceOpenPoolList.size();

                for (InvoiceOpenPoolEntity entity:invoiceOpenPoolList){
                    if("del".equals(entity.getRowState())){
                        invoiceAuantity--;
                    }
                }

                invoiceOpenRegistEntity.setInvoiceAuantity(invoiceAuantity);

                //后期加参数在控制
                if (invoiceOpenRegistEntity.getId() != null){
                    invoiceOpenRegistEntity.setRegistState(0);
                    //有开票申请
                    super.updateById(invoiceOpenRegistEntity);

                }else{
                    String billCode =getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    //无开票申请直接保存
                    super.save(invoiceOpenRegistEntity);
                }

                for (InvoiceOpenPoolEntity pool : invoiceOpenPoolList){
                    if(invoiceOpenRegistEntity.getApplyId() != null){
                        pool.setOpenApplyType(1);//有申请
                        pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
                    }
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
                    pool.setContractId(invoiceOpenRegistEntity.getContractId());
                    pool.setContractName(invoiceOpenRegistEntity.getContractName());
                    pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                    pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                    pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
                    pool.setEmployeeId(invoiceOpenRegistEntity.getApplyerId());
                    pool.setEmployeeName(invoiceOpenRegistEntity.getApplyer());
                    pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                    pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
                    pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                    pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                    pool.setRegistId(invoiceOpenRegistEntity.getId());
                    pool.setRegistCode(invoiceOpenRegistEntity.getCode());
                    pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                    pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                    pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
                    pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
                    pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
                    pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
                    pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
                    if (StringUtils.isNotEmpty(pool.getRowState())  && "del".equals(pool.getRowState())){
                        invoiceOpenPoolService.removeById(pool.getId());
                    }else if(StringUtils.isEmpty(pool.getRowState())  || "edit".equals(pool.getRowState())){
                        invoiceOpenPoolService.updateById(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }else if (StringUtils.isNotEmpty(pool.getRowState())  && "add".equals(pool.getRowState())){
                        String billCode =getBillCode(BILL_POOL_CODE);
                        pool.setBillCode(billCode);
                        invoiceOpenPoolService.save(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }
                }

                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);

            }else{
                throw new BusinessException("发票信息不能为空");
            }

        }finally {
            lock.unlock(); //释放锁
        }

        return invoiceOpenRegistEntity;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 根据id查询带出 发票池数据
     * @param id
     * @return
     */
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity =this.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id" ,id);
        queryWrapper.eq("dr" ,0);
        List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            entity.setContractItemList(list);
        }
        return entity;
    }

    /**
     * 根据申请id查询一条数据
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("apply_id" ,applyId);
        InvoiceOpenRegistEntity entity =invoiceOpenRegistMapper.selectOne(queryWrapper);
        if(entity != null){
            QueryParam param = new QueryParam();
            param.getParams().put("registId",new Parameter(QueryParam.EQ,entity.getId()));
            List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                entity.setContractItemList(list);
            }
        }
        return entity;
    }

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date) {
        if(date.length() == 5){
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DoubleToDate(Double.parseDouble(date));
                return sdf.format(tDate);
            }catch (Exception e){
                e.printStackTrace();
                return date;
            }
        }
        return date;
    }

    /**
     * 根据合同id统计发票金额
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> selectSumInvoiceMny(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<InvoiceOpenRegistEntity>();
        query.select("  sum(invoice_mny) as totalInvoiceMny ");
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalInvoiceMny", null != data.get("totalInvoiceMny") ? new BigDecimal(data.get("totalInvoiceMny").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalInvoiceMny", BigDecimal.ZERO);
        }
        return resp;
    }

    //解析Excel日期格式
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));
        return tDate;
    }

    /**
     * 验证发票是否重复
     * @param poolList
     * @return
     */
    public void checkPool(List<InvoiceOpenPoolEntity> poolList){
        List<String> invoiceNumberParamList = new ArrayList<>();
        for (int i = 0; i < poolList.size(); i++) {
            InvoiceOpenPoolEntity vo = poolList.get(i);
            if("add".equals(vo.getRowState()) || "edit".equals(vo.getRowState())){
                invoiceNumberParamList.add(vo.getInvoiceNumber());
                for (int j = i+1; j < poolList.size(); j++) {
                    InvoiceOpenPoolEntity poolVo = poolList.get(j);
                    if (vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) {
                        throw new BusinessException("发票号码第" + (i+1) + "行和第" + (j+1) + "重复");
                    }
                }
            }
        }

        if(CollectionUtils.isNotEmpty(invoiceNumberParamList)){
            checkInvoiceNumber(poolList,invoiceNumberParamList);
        }
    }

    /**
     * 删除
     * @param vos
     * @return
     */
    @Transactional
    public CommonResponse<String> delete(List<InvoiceOpenRegistVO> vos) {
        List<Long> ids = vos.stream().map(InvoiceOpenRegistVO::getId).collect(Collectors.toList());
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("dr", 1,3);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.in("regist_id", ids);
        List<InvoiceOpenPoolVO> list = invoiceOpenPoolService.queryList(queryWrapper);
        if(list!=null&&list.size()>0){
            String message = "";
            List<InvoiceOpenRegistEntity> entitys = (List<InvoiceOpenRegistEntity>) this.listByIds(list.stream().map(InvoiceOpenPoolVO::getRegistId).collect(Collectors.toList()));
            for(InvoiceOpenRegistEntity entity : entitys){
                if(message.length()>0){
                    message += ("、" + entity.getCode());
                }else{
                    message += entity.getCode();
                }
            }
            if(message.length()>0){
                return CommonResponse.error("以下登记："+message+"存在发票数据，不能删除！！！");
            }
        }

        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<>();
        query.eq("dr", 0);
        query.in("id", ids);
        List<InvoiceOpenRegistEntity> registList = super.list(query);
        List<Long> applyIds = registList.stream().map(InvoiceOpenRegistEntity::getApplyId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(registList)){
            UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id",applyIds);
            wrapper.set("open_type",0);//改成为登记状态
            invoiceOpenApplyService.update(wrapper);
        }

        this.removeByIds(ids,true);
        invoiceOpenPoolService.deleteBatchRegistId(ids);
        return CommonResponse.success("删除登记成功");
    }

    @Override
    public List<InvoiceOpenRegistVO> querylist(QueryWrapper<InvoiceOpenRegistEntity> queryWrapper) {
        List<InvoiceOpenRegistEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InvoiceOpenRegistVO.class);
    }


    /**
     * 查询发票号码
     * @param poolList
     * @param invoiceNumberParamList
     */
    public void checkInvoiceNumber(List<InvoiceOpenPoolEntity> poolList,List<String> invoiceNumberParamList){
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in("invoice_number",invoiceNumberParamList);
        queryWrapper.eq("dr",0);
        List<InvoiceOpenPoolEntity> openPoolEntityList =invoiceOpenPoolService.list(queryWrapper);
        Map<String, InvoiceOpenPoolEntity> poolMap = new HashMap<>();

        for(InvoiceOpenPoolEntity entity:poolList){
            if("add".equals(entity.getRowState()) || "edit".equals(entity.getRowState())){
                poolMap.put(entity.getInvoiceNumber(),entity);
            }
        }

        List<InvoiceOpenPoolEntity> restList = new LinkedList<>();
        for(InvoiceOpenPoolEntity poolEntity:openPoolEntityList){
            if(poolMap.containsKey(poolEntity.getInvoiceNumber())){
                restList.add(poolEntity);
            }
        }

        if(CollectionUtils.isNotEmpty(restList)){
            for (InvoiceOpenPoolEntity e:restList){
                throw new BusinessException("发票号码"+e.getInvoiceNumber()+"已经存在");
            }
        }

    }
}
