/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillSubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceDeducBill")
public class InvoiceDeducBillBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IInvoiceDeducBillService service;
    @Autowired
    private IInvoiceDeducApplySubService applySubService;
    @Autowired
    private IInvoiceReceivePoolService poolService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setAlreadyDeduc(true);
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            InvoiceDeducApplySubEntity applySubEntity = (InvoiceDeducApplySubEntity)((Object)this.applySubService.selectById(sub.getApplySubId()));
            InvoiceReceivePoolEntity poolEntity = (InvoiceReceivePoolEntity)((Object)this.poolService.selectById(sub.getInvoiceId()));
            if (applySubEntity != null) {
                applySubEntity.setActualDeducMny(sub.getActualDeducMny());
                applySubEntity.setActualDeducTaxMny(sub.getActualDeducTaxMny());
                applySubEntity.setAlreadyDeduc(true);
                applySubEntity.setDeducDate(sub.getCreateTime());
                this.applySubService.saveOrUpdateNoES((Object)applySubEntity);
            }
            if (poolEntity == null) continue;
            poolEntity.setActualDeductionMny(sub.getActualDeducMny());
            poolEntity.setActualDeductionTax(sub.getActualDeducTaxMny());
            poolEntity.setDeductionState(1);
            this.poolService.saveOrUpdateNoES((Object)poolEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setAlreadyDeduc(false);
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            InvoiceDeducApplySubEntity applySubEntity = (InvoiceDeducApplySubEntity)((Object)this.applySubService.selectById(sub.getApplySubId()));
            InvoiceReceivePoolEntity poolEntity = (InvoiceReceivePoolEntity)((Object)this.poolService.selectById(sub.getInvoiceId()));
            if (applySubEntity != null) {
                applySubEntity.setActualDeducMny(BigDecimal.ZERO);
                applySubEntity.setActualDeducTaxMny(BigDecimal.ZERO);
                applySubEntity.setAlreadyDeduc(false);
                applySubEntity.setDeducDate(null);
                this.applySubService.saveOrUpdateNoES((Object)applySubEntity);
            }
            if (poolEntity == null) continue;
            poolEntity.setActualDeductionMny(BigDecimal.ZERO);
            poolEntity.setActualDeductionTax(BigDecimal.ZERO);
            poolEntity.setDeductionState(0);
            this.poolService.saveOrUpdateNoES((Object)poolEntity);
        }
        return CommonResponse.success();
    }
}

